package org.wildfly.swarm.config.resource.adapters.resource_adapter;

import org.wildfly.swarm.config.resource.adapters.resource_adapter.ConnectionDefinitions;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ConnectionDefinitionsConsumer<T extends ConnectionDefinitions<T>> {

	/**
	 * Configure a pre-constructed instance of ConnectionDefinitions resource
	 * 
	 * @parameter Instance of ConnectionDefinitions to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConnectionDefinitionsConsumer<T> andThen(
			ConnectionDefinitionsConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}