package org.wildfly.swarm.config.security;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * Security Vault for attributes.
 */
@Address("/subsystem=security/vault=classic")
@ResourceType("vault")
@Implicit
public class ClassicVault<T extends ClassicVault<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String code;
	private Map vaultOptions;

	public ClassicVault() {
		this.key = "classic";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Fully Qualified Name of the Security Vault Implementation.
	 */
	@ModelNodeBinding(detypedName = "code")
	public String code() {
		return this.code;
	}

	/**
	 * Fully Qualified Name of the Security Vault Implementation.
	 */
	@SuppressWarnings("unchecked")
	public T code(String value) {
		Object oldValue = this.code;
		this.code = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("code", oldValue, value);
		return (T) this;
	}

	/**
	 * Security Vault options.
	 */
	@ModelNodeBinding(detypedName = "vault-options")
	public Map vaultOptions() {
		return this.vaultOptions;
	}

	/**
	 * Security Vault options.
	 */
	@SuppressWarnings("unchecked")
	public T vaultOptions(Map value) {
		Object oldValue = this.vaultOptions;
		this.vaultOptions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("vaultOptions", oldValue, value);
		return (T) this;
	}

	/**
	 * Security Vault options.
	 */
	@SuppressWarnings("unchecked")
	public T vaultOption(String key, Object value) {
		if (this.vaultOptions == null) {
			this.vaultOptions = new java.util.HashMap<>();
		}
		this.vaultOptions.put(key, value);
		return (T) this;
	}
}