package org.wildfly.swarm.config.security.security_domain.authentication;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import org.wildfly.swarm.config.security.Flag;
import java.util.Map;
/**
 * List of modules that map principal, role, and credential information
 */
@Address("/subsystem=security/security-domain=*/authentication=jaspi/auth-module=*")
@ResourceType("auth-module")
public class AuthModule<T extends AuthModule<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String code;
	private Flag flag;
	private String loginModuleStackRef;
	private String module;
	private Map moduleOptions;

	public AuthModule(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@ModelNodeBinding(detypedName = "code")
	public String code() {
		return this.code;
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@SuppressWarnings("unchecked")
	public T code(String value) {
		Object oldValue = this.code;
		this.code = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("code", oldValue, value);
		return (T) this;
	}

	/**
	 * The flag controls how the module participates in the overall procedure.
	 * Allowed values are requisite, required, sufficient or optional.
	 */
	@ModelNodeBinding(detypedName = "flag")
	public Flag flag() {
		return this.flag;
	}

	/**
	 * The flag controls how the module participates in the overall procedure.
	 * Allowed values are requisite, required, sufficient or optional.
	 */
	@SuppressWarnings("unchecked")
	public T flag(Flag value) {
		Object oldValue = this.flag;
		this.flag = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("flag", oldValue, value);
		return (T) this;
	}

	/**
	 * Reference to a login module stack name previously configured in the same
	 * security domain.
	 */
	@ModelNodeBinding(detypedName = "login-module-stack-ref")
	public String loginModuleStackRef() {
		return this.loginModuleStackRef;
	}

	/**
	 * Reference to a login module stack name previously configured in the same
	 * security domain.
	 */
	@SuppressWarnings("unchecked")
	public T loginModuleStackRef(String value) {
		Object oldValue = this.loginModuleStackRef;
		this.loginModuleStackRef = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("loginModuleStackRef", oldValue, value);
		return (T) this;
	}

	/**
	 * Name of JBoss Module where the mapping module code is located.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * Name of JBoss Module where the mapping module code is located.
	 */
	@SuppressWarnings("unchecked")
	public T module(String value) {
		Object oldValue = this.module;
		this.module = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("module", oldValue, value);
		return (T) this;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@ModelNodeBinding(detypedName = "module-options")
	public Map moduleOptions() {
		return this.moduleOptions;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@SuppressWarnings("unchecked")
	public T moduleOptions(Map value) {
		Object oldValue = this.moduleOptions;
		this.moduleOptions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("moduleOptions", oldValue, value);
		return (T) this;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@SuppressWarnings("unchecked")
	public T moduleOption(String key, Object value) {
		if (this.moduleOptions == null) {
			this.moduleOptions = new java.util.HashMap<>();
		}
		this.moduleOptions.put(key, value);
		return (T) this;
	}
}