package org.wildfly.swarm.config.transactions.log_store.transactions;

import org.wildfly.swarm.config.transactions.log_store.transactions.Participants;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ParticipantsConsumer<T extends Participants<T>> {

	/**
	 * Configure a pre-constructed instance of Participants resource
	 * 
	 * @parameter Instance of Participants to configure
	 * @return nothing
	 */
	void accept(T value);

	default ParticipantsConsumer<T> andThen(ParticipantsConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}