package org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer;

import org.wildfly.swarm.config.undertow.configuration.mod_cluster.balancer.Node;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface NodeConsumer<T extends Node<T>> {

	/**
	 * Configure a pre-constructed instance of Node resource
	 * 
	 * @parameter Instance of Node to configure
	 * @return nothing
	 */
	void accept(T value);

	default NodeConsumer<T> andThen(NodeConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}