/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.wildfly.swarm.config.management.Property;
import org.wildfly.swarm.config.management.PropertyConsumer;
import org.wildfly.swarm.config.management.PropertySupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/core-service=management/ldap-connection=*")
@ResourceType(value="ldap-connection")
public class LdapConnection<T extends LdapConnection<T>> {
    private String key;
    private PropertyChangeSupport pcs;
    private LdapConnectionResources subresources = new LdapConnectionResources();
    private List<String> handlesReferralsFor;
    private String initialContextFactory;
    private Referrals referrals;
    private String searchCredential;
    private String searchDn;
    private String securityRealm;
    private String url;

    public LdapConnection(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public LdapConnectionResources subresources() {
        return this.subresources;
    }

    public T properties(List<Property> value) {
        this.subresources.properties = value;
        return (T)this;
    }

    public T property(Property value) {
        this.subresources.properties.add(value);
        return (T)this;
    }

    public T property(String childKey, PropertyConsumer consumer) {
        Property child = new Property(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.property(child);
        return (T)this;
    }

    public T property(String childKey) {
        this.property(childKey, null);
        return (T)this;
    }

    public T property(PropertySupplier supplier) {
        this.property(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="handles-referrals-for")
    public List<String> handlesReferralsFor() {
        return this.handlesReferralsFor;
    }

    public T handlesReferralsFor(List<String> value) {
        List<String> oldValue = this.handlesReferralsFor;
        this.handlesReferralsFor = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("handlesReferralsFor", oldValue, value);
        }
        return (T)this;
    }

    public T handlesReferralsFor(String value) {
        if (this.handlesReferralsFor == null) {
            this.handlesReferralsFor = new ArrayList<String>();
        }
        this.handlesReferralsFor.add(value);
        return (T)this;
    }

    public T handlesReferralsFor(String ... args) {
        this.handlesReferralsFor(Arrays.asList(args));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="initial-context-factory")
    public String initialContextFactory() {
        return this.initialContextFactory;
    }

    public T initialContextFactory(String value) {
        String oldValue = this.initialContextFactory;
        this.initialContextFactory = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("initialContextFactory", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="referrals")
    public Referrals referrals() {
        return this.referrals;
    }

    public T referrals(Referrals value) {
        Referrals oldValue = this.referrals;
        this.referrals = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("referrals", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="search-credential")
    public String searchCredential() {
        return this.searchCredential;
    }

    public T searchCredential(String value) {
        String oldValue = this.searchCredential;
        this.searchCredential = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("searchCredential", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="search-dn")
    public String searchDn() {
        return this.searchDn;
    }

    public T searchDn(String value) {
        String oldValue = this.searchDn;
        this.searchDn = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("searchDn", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-realm")
    public String securityRealm() {
        return this.securityRealm;
    }

    public T securityRealm(String value) {
        String oldValue = this.securityRealm;
        this.securityRealm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityRealm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="url")
    public String url() {
        return this.url;
    }

    public T url(String value) {
        String oldValue = this.url;
        this.url = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("url", oldValue, value);
        }
        return (T)this;
    }

    public static enum Referrals {
        FOLLOW("FOLLOW"),
        IGNORE("IGNORE"),
        THROW("THROW");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private Referrals(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static class LdapConnectionResources {
        private List<Property> properties = new ArrayList<Property>();

        @Subresource
        public List<Property> properties() {
            return this.properties;
        }

        public Property property(String key) {
            return this.properties.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

