/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.configuration.File;
import org.wildfly.swarm.config.undertow.configuration.FileConsumer;
import org.wildfly.swarm.config.undertow.configuration.FileSupplier;
import org.wildfly.swarm.config.undertow.configuration.ReverseProxy;
import org.wildfly.swarm.config.undertow.configuration.ReverseProxyConsumer;
import org.wildfly.swarm.config.undertow.configuration.ReverseProxySupplier;

@Address(value="/subsystem=undertow/configuration=handler")
@ResourceType(value="configuration")
@Implicit
public class HandlerConfiguration<T extends HandlerConfiguration<T>> {
    private String key = "handler";
    private PropertyChangeSupport pcs;
    private HandlerConfigurationResources subresources = new HandlerConfigurationResources();

    public HandlerConfiguration() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public HandlerConfigurationResources subresources() {
        return this.subresources;
    }

    public T reverseProxies(List<ReverseProxy> value) {
        this.subresources.reverseProxies = value;
        return (T)this;
    }

    public T reverseProxy(ReverseProxy value) {
        this.subresources.reverseProxies.add(value);
        return (T)this;
    }

    public T reverseProxy(String childKey, ReverseProxyConsumer consumer) {
        ReverseProxy child = new ReverseProxy(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.reverseProxy(child);
        return (T)this;
    }

    public T reverseProxy(String childKey) {
        this.reverseProxy(childKey, null);
        return (T)this;
    }

    public T reverseProxy(ReverseProxySupplier supplier) {
        this.reverseProxy(supplier.get());
        return (T)this;
    }

    public T files(List<File> value) {
        this.subresources.files = value;
        return (T)this;
    }

    public T file(File value) {
        this.subresources.files.add(value);
        return (T)this;
    }

    public T file(String childKey, FileConsumer consumer) {
        File child = new File(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.file(child);
        return (T)this;
    }

    public T file(String childKey) {
        this.file(childKey, null);
        return (T)this;
    }

    public T file(FileSupplier supplier) {
        this.file(supplier.get());
        return (T)this;
    }

    public static class HandlerConfigurationResources {
        private List<ReverseProxy> reverseProxies = new ArrayList<ReverseProxy>();
        private List<File> files = new ArrayList<File>();

        @Subresource
        public List<ReverseProxy> reverseProxies() {
            return this.reverseProxies;
        }

        public ReverseProxy reverseProxy(String key) {
            return this.reverseProxies.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<File> files() {
            return this.files;
        }

        public File file(String key) {
            return this.files.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

