package org.wildfly.swarm.config.datasources.data_source;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The connection-properties element allows you to pass in arbitrary connection
 * properties to the Driver.connect(url, props) method
 */
@Address("/subsystem=datasources/data-source=*/connection-properties=*")
@ResourceType("connection-properties")
public class ConnectionProperties<T extends ConnectionProperties<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String value;

	public ConnectionProperties(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Each connection-property specifies a string name/value pair with the
	 * property name coming from the name attribute and the value coming from
	 * the element content
	 */
	@ModelNodeBinding(detypedName = "value")
	public String value() {
		return this.value;
	}

	/**
	 * Each connection-property specifies a string name/value pair with the
	 * property name coming from the name attribute and the value coming from
	 * the element content
	 */
	@SuppressWarnings("unchecked")
	public T value(String value) {
		Object oldValue = this.value;
		this.value = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("value", oldValue, value);
		return (T) this;
	}
}