package org.wildfly.swarm.config.ejb3.remoting_profile;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.ejb3.ChannelCreationOptionsConsumer;
import org.wildfly.swarm.config.ejb3.ChannelCreationOptionsSupplier;
import org.wildfly.swarm.config.ejb3.ChannelCreationOptions;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A remoting ejb receiver reference included in the profile
 */
@Address("/subsystem=ejb3/remoting-profile=*/remoting-ejb-receiver=*")
@ResourceType("remoting-ejb-receiver")
public class RemotingEJBReceiver<T extends RemotingEJBReceiver<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private RemotingEJBReceiverResources subresources = new RemotingEJBReceiverResources();
	private Long connectTimeout;
	private String outboundConnectionRef;

	public RemotingEJBReceiver(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public RemotingEJBReceiverResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all ChannelCreationOptions objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ChannelCreationOptions objects.
	 */
	@SuppressWarnings("unchecked")
	public T channelCreationOptions(List<ChannelCreationOptions> value) {
		this.subresources.channelCreationOptions = value;
		return (T) this;
	}

	/**
	 * Add the ChannelCreationOptions object to the list of subresources
	 * 
	 * @param value
	 *            The ChannelCreationOptions to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T channelCreationOptions(ChannelCreationOptions value) {
		this.subresources.channelCreationOptions.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ChannelCreationOptions object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ChannelCreationOptions resource
	 * @param config
	 *            The ChannelCreationOptionsConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T channelCreationOptions(String childKey,
			ChannelCreationOptionsConsumer consumer) {
		ChannelCreationOptions<? extends ChannelCreationOptions> child = new ChannelCreationOptions<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		channelCreationOptions(child);
		return (T) this;
	}

	/**
	 * Create and configure a ChannelCreationOptions object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ChannelCreationOptions resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T channelCreationOptions(String childKey) {
		channelCreationOptions(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ChannelCreationOptions object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T channelCreationOptions(ChannelCreationOptionsSupplier supplier) {
		channelCreationOptions(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for RemotingEJBReceiver
	 */
	public static class RemotingEJBReceiverResources {
		/**
		 * The options that will be used during the EJB remote channel creation
		 */
		private List<ChannelCreationOptions> channelCreationOptions = new java.util.ArrayList<>();

		/**
		 * Get the list of ChannelCreationOptions resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ChannelCreationOptions> channelCreationOptions() {
			return this.channelCreationOptions;
		}

		public ChannelCreationOptions channelCreationOptions(String key) {
			return this.channelCreationOptions.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}

	/**
	 * Remoting ejb receiver connect timeout
	 */
	@ModelNodeBinding(detypedName = "connect-timeout")
	public Long connectTimeout() {
		return this.connectTimeout;
	}

	/**
	 * Remoting ejb receiver connect timeout
	 */
	@SuppressWarnings("unchecked")
	public T connectTimeout(Long value) {
		Object oldValue = this.connectTimeout;
		this.connectTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * Name of outbound connection that will be used by the ejb receiver
	 */
	@ModelNodeBinding(detypedName = "outbound-connection-ref")
	public String outboundConnectionRef() {
		return this.outboundConnectionRef;
	}

	/**
	 * Name of outbound connection that will be used by the ejb receiver
	 */
	@SuppressWarnings("unchecked")
	public T outboundConnectionRef(String value) {
		Object oldValue = this.outboundConnectionRef;
		this.outboundConnectionRef = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("outboundConnectionRef", oldValue,
					value);
		return (T) this;
	}
}