package org.wildfly.swarm.config.infinispan;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.infinispan.cache_container.InvalidationCacheConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.InvalidationCacheSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.InvalidationCache;
import org.wildfly.swarm.config.infinispan.cache_container.LocalCacheConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.LocalCacheSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.LocalCache;
import org.wildfly.swarm.config.infinispan.cache_container.ReplicatedCacheConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.ReplicatedCacheSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.ReplicatedCache;
import org.wildfly.swarm.config.infinispan.cache_container.DistributedCacheConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.DistributedCacheSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.DistributedCache;
import org.wildfly.swarm.config.infinispan.cache_container.RemoteCommandThreadPool;
import org.wildfly.swarm.config.infinispan.cache_container.RemoteCommandThreadPoolConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.RemoteCommandThreadPoolSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.JGroupsTransport;
import org.wildfly.swarm.config.infinispan.cache_container.JGroupsTransportConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.JGroupsTransportSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.AsyncOperationsThreadPool;
import org.wildfly.swarm.config.infinispan.cache_container.AsyncOperationsThreadPoolConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.AsyncOperationsThreadPoolSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.ExpirationThreadPool;
import org.wildfly.swarm.config.infinispan.cache_container.ExpirationThreadPoolConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.ExpirationThreadPoolSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.TransportThreadPool;
import org.wildfly.swarm.config.infinispan.cache_container.TransportThreadPoolConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.TransportThreadPoolSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.NoneTransport;
import org.wildfly.swarm.config.infinispan.cache_container.NoneTransportConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.NoneTransportSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.PersistenceThreadPool;
import org.wildfly.swarm.config.infinispan.cache_container.PersistenceThreadPoolConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.PersistenceThreadPoolSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.ListenerThreadPool;
import org.wildfly.swarm.config.infinispan.cache_container.ListenerThreadPoolConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.ListenerThreadPoolSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.StateTransferThreadPool;
import org.wildfly.swarm.config.infinispan.cache_container.StateTransferThreadPoolConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.StateTransferThreadPoolSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
/**
 * The configuration of an infinispan cache container
 */
@Address("/subsystem=infinispan/cache-container=*")
@ResourceType("cache-container")
public class CacheContainer<T extends CacheContainer<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private CacheContainerResources subresources = new CacheContainerResources();
	private List<String> aliases;
	private String cacheManagerStatus;
	private String clusterName;
	private String coordinatorAddress;
	private String defaultCache;
	private Boolean isCoordinator;
	private String jndiName;
	private String localAddress;
	private String module;
	private Boolean statisticsEnabled;

	public CacheContainer(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public CacheContainerResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all InvalidationCache objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of InvalidationCache objects.
	 */
	@SuppressWarnings("unchecked")
	public T invalidationCaches(List<InvalidationCache> value) {
		this.subresources.invalidationCaches = value;
		return (T) this;
	}

	/**
	 * Add the InvalidationCache object to the list of subresources
	 * 
	 * @param value
	 *            The InvalidationCache to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T invalidationCache(InvalidationCache value) {
		this.subresources.invalidationCaches.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a InvalidationCache object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the InvalidationCache resource
	 * @param config
	 *            The InvalidationCacheConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T invalidationCache(String childKey,
			InvalidationCacheConsumer consumer) {
		InvalidationCache<? extends InvalidationCache> child = new InvalidationCache<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		invalidationCache(child);
		return (T) this;
	}

	/**
	 * Create and configure a InvalidationCache object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the InvalidationCache resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T invalidationCache(String childKey) {
		invalidationCache(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied InvalidationCache object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T invalidationCache(InvalidationCacheSupplier supplier) {
		invalidationCache(supplier.get());
		return (T) this;
	}

	/**
	 * Add all LocalCache objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of LocalCache objects.
	 */
	@SuppressWarnings("unchecked")
	public T localCaches(List<LocalCache> value) {
		this.subresources.localCaches = value;
		return (T) this;
	}

	/**
	 * Add the LocalCache object to the list of subresources
	 * 
	 * @param value
	 *            The LocalCache to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T localCache(LocalCache value) {
		this.subresources.localCaches.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a LocalCache object to the list of subresources
	 * 
	 * @param key
	 *            The key for the LocalCache resource
	 * @param config
	 *            The LocalCacheConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T localCache(String childKey, LocalCacheConsumer consumer) {
		LocalCache<? extends LocalCache> child = new LocalCache<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		localCache(child);
		return (T) this;
	}

	/**
	 * Create and configure a LocalCache object to the list of subresources
	 * 
	 * @param key
	 *            The key for the LocalCache resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T localCache(String childKey) {
		localCache(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied LocalCache object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T localCache(LocalCacheSupplier supplier) {
		localCache(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ReplicatedCache objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ReplicatedCache objects.
	 */
	@SuppressWarnings("unchecked")
	public T replicatedCaches(List<ReplicatedCache> value) {
		this.subresources.replicatedCaches = value;
		return (T) this;
	}

	/**
	 * Add the ReplicatedCache object to the list of subresources
	 * 
	 * @param value
	 *            The ReplicatedCache to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T replicatedCache(ReplicatedCache value) {
		this.subresources.replicatedCaches.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ReplicatedCache object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ReplicatedCache resource
	 * @param config
	 *            The ReplicatedCacheConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T replicatedCache(String childKey, ReplicatedCacheConsumer consumer) {
		ReplicatedCache<? extends ReplicatedCache> child = new ReplicatedCache<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		replicatedCache(child);
		return (T) this;
	}

	/**
	 * Create and configure a ReplicatedCache object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ReplicatedCache resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T replicatedCache(String childKey) {
		replicatedCache(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ReplicatedCache object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T replicatedCache(ReplicatedCacheSupplier supplier) {
		replicatedCache(supplier.get());
		return (T) this;
	}

	/**
	 * Add all DistributedCache objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of DistributedCache objects.
	 */
	@SuppressWarnings("unchecked")
	public T distributedCaches(List<DistributedCache> value) {
		this.subresources.distributedCaches = value;
		return (T) this;
	}

	/**
	 * Add the DistributedCache object to the list of subresources
	 * 
	 * @param value
	 *            The DistributedCache to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T distributedCache(DistributedCache value) {
		this.subresources.distributedCaches.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a DistributedCache object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the DistributedCache resource
	 * @param config
	 *            The DistributedCacheConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T distributedCache(String childKey, DistributedCacheConsumer consumer) {
		DistributedCache<? extends DistributedCache> child = new DistributedCache<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		distributedCache(child);
		return (T) this;
	}

	/**
	 * Create and configure a DistributedCache object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the DistributedCache resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T distributedCache(String childKey) {
		distributedCache(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied DistributedCache object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T distributedCache(DistributedCacheSupplier supplier) {
		distributedCache(supplier.get());
		return (T) this;
	}

	/**
	 * Defines a thread pool used to execute remote commands.
	 */
	@SuppressWarnings("unchecked")
	public T remoteCommandThreadPool(RemoteCommandThreadPool value) {
		this.subresources.remoteCommandThreadPool = value;
		return (T) this;
	}

	/**
	 * Defines a thread pool used to execute remote commands.
	 */
	@SuppressWarnings("unchecked")
	public T remoteCommandThreadPool(RemoteCommandThreadPoolConsumer consumer) {
		RemoteCommandThreadPool<? extends RemoteCommandThreadPool> child = new RemoteCommandThreadPool<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.remoteCommandThreadPool = child;
		return (T) this;
	}

	/**
	 * Defines a thread pool used to execute remote commands.
	 */
	@SuppressWarnings("unchecked")
	public T remoteCommandThreadPool() {
		RemoteCommandThreadPool<? extends RemoteCommandThreadPool> child = new RemoteCommandThreadPool<>();
		this.subresources.remoteCommandThreadPool = child;
		return (T) this;
	}

	/**
	 * Defines a thread pool used to execute remote commands.
	 */
	@SuppressWarnings("unchecked")
	public T remoteCommandThreadPool(RemoteCommandThreadPoolSupplier supplier) {
		this.subresources.remoteCommandThreadPool = supplier.get();
		return (T) this;
	}

	/**
	 * The description of the transport used by this cache container
	 */
	@SuppressWarnings("unchecked")
	public T jgroupsTransport(JGroupsTransport value) {
		this.subresources.jgroupsTransport = value;
		return (T) this;
	}

	/**
	 * The description of the transport used by this cache container
	 */
	@SuppressWarnings("unchecked")
	public T jgroupsTransport(JGroupsTransportConsumer consumer) {
		JGroupsTransport<? extends JGroupsTransport> child = new JGroupsTransport<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.jgroupsTransport = child;
		return (T) this;
	}

	/**
	 * The description of the transport used by this cache container
	 */
	@SuppressWarnings("unchecked")
	public T jgroupsTransport() {
		JGroupsTransport<? extends JGroupsTransport> child = new JGroupsTransport<>();
		this.subresources.jgroupsTransport = child;
		return (T) this;
	}

	/**
	 * The description of the transport used by this cache container
	 */
	@SuppressWarnings("unchecked")
	public T jgroupsTransport(JGroupsTransportSupplier supplier) {
		this.subresources.jgroupsTransport = supplier.get();
		return (T) this;
	}

	/**
	 * Defines a thread pool used for asynchronous operations.
	 */
	@SuppressWarnings("unchecked")
	public T asyncOperationsThreadPool(AsyncOperationsThreadPool value) {
		this.subresources.asyncOperationsThreadPool = value;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for asynchronous operations.
	 */
	@SuppressWarnings("unchecked")
	public T asyncOperationsThreadPool(
			AsyncOperationsThreadPoolConsumer consumer) {
		AsyncOperationsThreadPool<? extends AsyncOperationsThreadPool> child = new AsyncOperationsThreadPool<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.asyncOperationsThreadPool = child;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for asynchronous operations.
	 */
	@SuppressWarnings("unchecked")
	public T asyncOperationsThreadPool() {
		AsyncOperationsThreadPool<? extends AsyncOperationsThreadPool> child = new AsyncOperationsThreadPool<>();
		this.subresources.asyncOperationsThreadPool = child;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for asynchronous operations.
	 */
	@SuppressWarnings("unchecked")
	public T asyncOperationsThreadPool(
			AsyncOperationsThreadPoolSupplier supplier) {
		this.subresources.asyncOperationsThreadPool = supplier.get();
		return (T) this;
	}

	/**
	 * Defines a thread pool used for for evictions.
	 */
	@SuppressWarnings("unchecked")
	public T expirationThreadPool(ExpirationThreadPool value) {
		this.subresources.expirationThreadPool = value;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for for evictions.
	 */
	@SuppressWarnings("unchecked")
	public T expirationThreadPool(ExpirationThreadPoolConsumer consumer) {
		ExpirationThreadPool<? extends ExpirationThreadPool> child = new ExpirationThreadPool<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.expirationThreadPool = child;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for for evictions.
	 */
	@SuppressWarnings("unchecked")
	public T expirationThreadPool() {
		ExpirationThreadPool<? extends ExpirationThreadPool> child = new ExpirationThreadPool<>();
		this.subresources.expirationThreadPool = child;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for for evictions.
	 */
	@SuppressWarnings("unchecked")
	public T expirationThreadPool(ExpirationThreadPoolSupplier supplier) {
		this.subresources.expirationThreadPool = supplier.get();
		return (T) this;
	}

	/**
	 * Defines a thread pool used for asynchronous transport communication.
	 */
	@SuppressWarnings("unchecked")
	public T transportThreadPool(TransportThreadPool value) {
		this.subresources.transportThreadPool = value;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for asynchronous transport communication.
	 */
	@SuppressWarnings("unchecked")
	public T transportThreadPool(TransportThreadPoolConsumer consumer) {
		TransportThreadPool<? extends TransportThreadPool> child = new TransportThreadPool<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.transportThreadPool = child;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for asynchronous transport communication.
	 */
	@SuppressWarnings("unchecked")
	public T transportThreadPool() {
		TransportThreadPool<? extends TransportThreadPool> child = new TransportThreadPool<>();
		this.subresources.transportThreadPool = child;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for asynchronous transport communication.
	 */
	@SuppressWarnings("unchecked")
	public T transportThreadPool(TransportThreadPoolSupplier supplier) {
		this.subresources.transportThreadPool = supplier.get();
		return (T) this;
	}

	/**
	 * A local-only transport used by this cache-container
	 */
	@SuppressWarnings("unchecked")
	public T noneTransport(NoneTransport value) {
		this.subresources.noneTransport = value;
		return (T) this;
	}

	/**
	 * A local-only transport used by this cache-container
	 */
	@SuppressWarnings("unchecked")
	public T noneTransport(NoneTransportConsumer consumer) {
		NoneTransport<? extends NoneTransport> child = new NoneTransport<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.noneTransport = child;
		return (T) this;
	}

	/**
	 * A local-only transport used by this cache-container
	 */
	@SuppressWarnings("unchecked")
	public T noneTransport() {
		NoneTransport<? extends NoneTransport> child = new NoneTransport<>();
		this.subresources.noneTransport = child;
		return (T) this;
	}

	/**
	 * A local-only transport used by this cache-container
	 */
	@SuppressWarnings("unchecked")
	public T noneTransport(NoneTransportSupplier supplier) {
		this.subresources.noneTransport = supplier.get();
		return (T) this;
	}

	/**
	 * Defines a thread pool used for interacting with the persistent store.
	 */
	@SuppressWarnings("unchecked")
	public T persistenceThreadPool(PersistenceThreadPool value) {
		this.subresources.persistenceThreadPool = value;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for interacting with the persistent store.
	 */
	@SuppressWarnings("unchecked")
	public T persistenceThreadPool(PersistenceThreadPoolConsumer consumer) {
		PersistenceThreadPool<? extends PersistenceThreadPool> child = new PersistenceThreadPool<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.persistenceThreadPool = child;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for interacting with the persistent store.
	 */
	@SuppressWarnings("unchecked")
	public T persistenceThreadPool() {
		PersistenceThreadPool<? extends PersistenceThreadPool> child = new PersistenceThreadPool<>();
		this.subresources.persistenceThreadPool = child;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for interacting with the persistent store.
	 */
	@SuppressWarnings("unchecked")
	public T persistenceThreadPool(PersistenceThreadPoolSupplier supplier) {
		this.subresources.persistenceThreadPool = supplier.get();
		return (T) this;
	}

	/**
	 * Defines a thread pool used for asynchronous cache listener notifications.
	 */
	@SuppressWarnings("unchecked")
	public T listenerThreadPool(ListenerThreadPool value) {
		this.subresources.listenerThreadPool = value;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for asynchronous cache listener notifications.
	 */
	@SuppressWarnings("unchecked")
	public T listenerThreadPool(ListenerThreadPoolConsumer consumer) {
		ListenerThreadPool<? extends ListenerThreadPool> child = new ListenerThreadPool<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.listenerThreadPool = child;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for asynchronous cache listener notifications.
	 */
	@SuppressWarnings("unchecked")
	public T listenerThreadPool() {
		ListenerThreadPool<? extends ListenerThreadPool> child = new ListenerThreadPool<>();
		this.subresources.listenerThreadPool = child;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for asynchronous cache listener notifications.
	 */
	@SuppressWarnings("unchecked")
	public T listenerThreadPool(ListenerThreadPoolSupplier supplier) {
		this.subresources.listenerThreadPool = supplier.get();
		return (T) this;
	}

	/**
	 * Defines a thread pool used for for state transfer.
	 */
	@SuppressWarnings("unchecked")
	public T stateTransferThreadPool(StateTransferThreadPool value) {
		this.subresources.stateTransferThreadPool = value;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for for state transfer.
	 */
	@SuppressWarnings("unchecked")
	public T stateTransferThreadPool(StateTransferThreadPoolConsumer consumer) {
		StateTransferThreadPool<? extends StateTransferThreadPool> child = new StateTransferThreadPool<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.stateTransferThreadPool = child;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for for state transfer.
	 */
	@SuppressWarnings("unchecked")
	public T stateTransferThreadPool() {
		StateTransferThreadPool<? extends StateTransferThreadPool> child = new StateTransferThreadPool<>();
		this.subresources.stateTransferThreadPool = child;
		return (T) this;
	}

	/**
	 * Defines a thread pool used for for state transfer.
	 */
	@SuppressWarnings("unchecked")
	public T stateTransferThreadPool(StateTransferThreadPoolSupplier supplier) {
		this.subresources.stateTransferThreadPool = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for CacheContainer
	 */
	public static class CacheContainerResources {
		/**
		 * An invalidation cache
		 */
		private List<InvalidationCache> invalidationCaches = new java.util.ArrayList<>();
		/**
		 * A local cache configuration
		 */
		private List<LocalCache> localCaches = new java.util.ArrayList<>();
		/**
		 * A replicated cache configuration
		 */
		private List<ReplicatedCache> replicatedCaches = new java.util.ArrayList<>();
		/**
		 * A distributed cache configuration.
		 */
		private List<DistributedCache> distributedCaches = new java.util.ArrayList<>();
		private RemoteCommandThreadPool remoteCommandThreadPool;
		private JGroupsTransport jgroupsTransport;
		private AsyncOperationsThreadPool asyncOperationsThreadPool;
		private ExpirationThreadPool expirationThreadPool;
		private TransportThreadPool transportThreadPool;
		private NoneTransport noneTransport;
		private PersistenceThreadPool persistenceThreadPool;
		private ListenerThreadPool listenerThreadPool;
		private StateTransferThreadPool stateTransferThreadPool;

		/**
		 * Get the list of InvalidationCache resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<InvalidationCache> invalidationCaches() {
			return this.invalidationCaches;
		}

		public InvalidationCache invalidationCache(String key) {
			return this.invalidationCaches.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of LocalCache resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<LocalCache> localCaches() {
			return this.localCaches;
		}

		public LocalCache localCache(String key) {
			return this.localCaches.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ReplicatedCache resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ReplicatedCache> replicatedCaches() {
			return this.replicatedCaches;
		}

		public ReplicatedCache replicatedCache(String key) {
			return this.replicatedCaches.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of DistributedCache resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<DistributedCache> distributedCaches() {
			return this.distributedCaches;
		}

		public DistributedCache distributedCache(String key) {
			return this.distributedCaches.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Defines a thread pool used to execute remote commands.
		 */
		@Subresource
		public RemoteCommandThreadPool remoteCommandThreadPool() {
			return this.remoteCommandThreadPool;
		}

		/**
		 * The description of the transport used by this cache container
		 */
		@Subresource
		public JGroupsTransport jgroupsTransport() {
			return this.jgroupsTransport;
		}

		/**
		 * Defines a thread pool used for asynchronous operations.
		 */
		@Subresource
		public AsyncOperationsThreadPool asyncOperationsThreadPool() {
			return this.asyncOperationsThreadPool;
		}

		/**
		 * Defines a thread pool used for for evictions.
		 */
		@Subresource
		public ExpirationThreadPool expirationThreadPool() {
			return this.expirationThreadPool;
		}

		/**
		 * Defines a thread pool used for asynchronous transport communication.
		 */
		@Subresource
		public TransportThreadPool transportThreadPool() {
			return this.transportThreadPool;
		}

		/**
		 * A local-only transport used by this cache-container
		 */
		@Subresource
		public NoneTransport noneTransport() {
			return this.noneTransport;
		}

		/**
		 * Defines a thread pool used for interacting with the persistent store.
		 */
		@Subresource
		public PersistenceThreadPool persistenceThreadPool() {
			return this.persistenceThreadPool;
		}

		/**
		 * Defines a thread pool used for asynchronous cache listener
		 * notifications.
		 */
		@Subresource
		public ListenerThreadPool listenerThreadPool() {
			return this.listenerThreadPool;
		}

		/**
		 * Defines a thread pool used for for state transfer.
		 */
		@Subresource
		public StateTransferThreadPool stateTransferThreadPool() {
			return this.stateTransferThreadPool;
		}
	}

	/**
	 * The list of aliases for this cache container
	 */
	@ModelNodeBinding(detypedName = "aliases")
	public List<String> aliases() {
		return this.aliases;
	}

	/**
	 * The list of aliases for this cache container
	 */
	@SuppressWarnings("unchecked")
	public T aliases(List<String> value) {
		Object oldValue = this.aliases;
		this.aliases = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("aliases", oldValue, value);
		return (T) this;
	}

	/**
	 * The list of aliases for this cache container
	 */
	@SuppressWarnings("unchecked")
	public T alias(String value) {
		if (this.aliases == null) {
			this.aliases = new java.util.ArrayList<>();
		}
		this.aliases.add(value);
		return (T) this;
	}

	/**
	 * The list of aliases for this cache container
	 */
	@SuppressWarnings("unchecked")
	public T aliases(String... args) {
		aliases(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * The status of the cache manager component. May return null if the cache
	 * manager is not started.
	 */
	@ModelNodeBinding(detypedName = "cache-manager-status")
	public String cacheManagerStatus() {
		return this.cacheManagerStatus;
	}

	/**
	 * The status of the cache manager component. May return null if the cache
	 * manager is not started.
	 */
	@SuppressWarnings("unchecked")
	public T cacheManagerStatus(String value) {
		Object oldValue = this.cacheManagerStatus;
		this.cacheManagerStatus = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cacheManagerStatus", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the cluster this node belongs to. May return null if the
	 * cache manager is not started.
	 */
	@ModelNodeBinding(detypedName = "cluster-name")
	public String clusterName() {
		return this.clusterName;
	}

	/**
	 * The name of the cluster this node belongs to. May return null if the
	 * cache manager is not started.
	 */
	@SuppressWarnings("unchecked")
	public T clusterName(String value) {
		Object oldValue = this.clusterName;
		this.clusterName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("clusterName", oldValue, value);
		return (T) this;
	}

	/**
	 * The logical address of the cluster's coordinator. May return null if the
	 * cache manager is not started.
	 */
	@ModelNodeBinding(detypedName = "coordinator-address")
	public String coordinatorAddress() {
		return this.coordinatorAddress;
	}

	/**
	 * The logical address of the cluster's coordinator. May return null if the
	 * cache manager is not started.
	 */
	@SuppressWarnings("unchecked")
	public T coordinatorAddress(String value) {
		Object oldValue = this.coordinatorAddress;
		this.coordinatorAddress = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("coordinatorAddress", oldValue, value);
		return (T) this;
	}

	/**
	 * The default infinispan cache
	 */
	@ModelNodeBinding(detypedName = "default-cache")
	public String defaultCache() {
		return this.defaultCache;
	}

	/**
	 * The default infinispan cache
	 */
	@SuppressWarnings("unchecked")
	public T defaultCache(String value) {
		Object oldValue = this.defaultCache;
		this.defaultCache = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultCache", oldValue, value);
		return (T) this;
	}

	/**
	 * Set to true if this node is the cluster's coordinator. May return null if
	 * the cache manager is not started.
	 */
	@ModelNodeBinding(detypedName = "is-coordinator")
	public Boolean isCoordinator() {
		return this.isCoordinator;
	}

	/**
	 * Set to true if this node is the cluster's coordinator. May return null if
	 * the cache manager is not started.
	 */
	@SuppressWarnings("unchecked")
	public T isCoordinator(Boolean value) {
		Object oldValue = this.isCoordinator;
		this.isCoordinator = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("isCoordinator", oldValue, value);
		return (T) this;
	}

	/**
	 * The jndi name to which to bind this cache container
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * The jndi name to which to bind this cache container
	 */
	@SuppressWarnings("unchecked")
	public T jndiName(String value) {
		Object oldValue = this.jndiName;
		this.jndiName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jndiName", oldValue, value);
		return (T) this;
	}

	/**
	 * The local address of the node. May return null if the cache manager is
	 * not started.
	 */
	@ModelNodeBinding(detypedName = "local-address")
	public String localAddress() {
		return this.localAddress;
	}

	/**
	 * The local address of the node. May return null if the cache manager is
	 * not started.
	 */
	@SuppressWarnings("unchecked")
	public T localAddress(String value) {
		Object oldValue = this.localAddress;
		this.localAddress = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("localAddress", oldValue, value);
		return (T) this;
	}

	/**
	 * The module whose class loader should be used when building this cache
	 * container's configuration.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * The module whose class loader should be used when building this cache
	 * container's configuration.
	 */
	@SuppressWarnings("unchecked")
	public T module(String value) {
		Object oldValue = this.module;
		this.module = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("module", oldValue, value);
		return (T) this;
	}

	/**
	 * If enabled, statistics will be collected for this cache container
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * If enabled, statistics will be collected for this cache container
	 */
	@SuppressWarnings("unchecked")
	public T statisticsEnabled(Boolean value) {
		Object oldValue = this.statisticsEnabled;
		this.statisticsEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
		return (T) this;
	}
}