package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.infinispan.cache_container.EvictionComponentConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.EvictionComponentSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.StringJDBCStoreConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.StringJDBCStoreSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.ExpirationComponentConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.ExpirationComponentSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.CustomStoreConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.CustomStoreSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.FileStoreConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.FileStoreSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.NoneStoreConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.NoneStoreSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.TransactionComponentConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.TransactionComponentSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.LockingComponentConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.LockingComponentSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.BinaryJDBCStoreConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.BinaryJDBCStoreSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.MixedJDBCStoreConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.MixedJDBCStoreSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.RemoteStoreConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.RemoteStoreSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A local cache configuration
 */
@Address("/subsystem=infinispan/cache-container=*/local-cache=*")
@ResourceType("local-cache")
public class LocalCache<T extends LocalCache<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private LocalCacheResources subresources = new LocalCacheResources();
	private Long activations;
	private Long averageReadTime;
	private Long averageWriteTime;
	private String cacheStatus;
	private Long elapsedTime;
	private Double hitRatio;
	private Long hits;
	private Long invalidations;
	private String jndiName;
	private Long misses;
	private String module;
	private Integer numberOfEntries;
	private Long passivations;
	private Double readWriteRatio;
	private Long removeHits;
	private Long removeMisses;
	private Boolean statisticsEnabled;
	private Long stores;
	private Long timeSinceReset;

	public LocalCache(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public LocalCacheResources subresources() {
		return this.subresources;
	}

	/**
	 * The cache eviction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T evictionComponent(EvictionComponent value) {
		this.subresources.evictionComponent = value;
		return (T) this;
	}

	/**
	 * The cache eviction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T evictionComponent(EvictionComponentConsumer consumer) {
		EvictionComponent<? extends EvictionComponent> child = new EvictionComponent<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.evictionComponent = child;
		return (T) this;
	}

	/**
	 * The cache eviction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T evictionComponent() {
		EvictionComponent<? extends EvictionComponent> child = new EvictionComponent<>();
		this.subresources.evictionComponent = child;
		return (T) this;
	}

	/**
	 * The cache eviction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T evictionComponent(EvictionComponentSupplier supplier) {
		this.subresources.evictionComponent = supplier.get();
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T stringJdbcStore(StringJDBCStore value) {
		this.subresources.stringJdbcStore = value;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T stringJdbcStore(StringJDBCStoreConsumer consumer) {
		StringJDBCStore<? extends StringJDBCStore> child = new StringJDBCStore<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.stringJdbcStore = child;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T stringJdbcStore() {
		StringJDBCStore<? extends StringJDBCStore> child = new StringJDBCStore<>();
		this.subresources.stringJdbcStore = child;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T stringJdbcStore(StringJDBCStoreSupplier supplier) {
		this.subresources.stringJdbcStore = supplier.get();
		return (T) this;
	}

	/**
	 * The cache expiration configuration.
	 */
	@SuppressWarnings("unchecked")
	public T expirationComponent(ExpirationComponent value) {
		this.subresources.expirationComponent = value;
		return (T) this;
	}

	/**
	 * The cache expiration configuration.
	 */
	@SuppressWarnings("unchecked")
	public T expirationComponent(ExpirationComponentConsumer consumer) {
		ExpirationComponent<? extends ExpirationComponent> child = new ExpirationComponent<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.expirationComponent = child;
		return (T) this;
	}

	/**
	 * The cache expiration configuration.
	 */
	@SuppressWarnings("unchecked")
	public T expirationComponent() {
		ExpirationComponent<? extends ExpirationComponent> child = new ExpirationComponent<>();
		this.subresources.expirationComponent = child;
		return (T) this;
	}

	/**
	 * The cache expiration configuration.
	 */
	@SuppressWarnings("unchecked")
	public T expirationComponent(ExpirationComponentSupplier supplier) {
		this.subresources.expirationComponent = supplier.get();
		return (T) this;
	}

	/**
	 * The cache store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T customStore(CustomStore value) {
		this.subresources.customStore = value;
		return (T) this;
	}

	/**
	 * The cache store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T customStore(CustomStoreConsumer consumer) {
		CustomStore<? extends CustomStore> child = new CustomStore<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.customStore = child;
		return (T) this;
	}

	/**
	 * The cache store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T customStore() {
		CustomStore<? extends CustomStore> child = new CustomStore<>();
		this.subresources.customStore = child;
		return (T) this;
	}

	/**
	 * The cache store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T customStore(CustomStoreSupplier supplier) {
		this.subresources.customStore = supplier.get();
		return (T) this;
	}

	/**
	 * The cache file store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T fileStore(FileStore value) {
		this.subresources.fileStore = value;
		return (T) this;
	}

	/**
	 * The cache file store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T fileStore(FileStoreConsumer consumer) {
		FileStore<? extends FileStore> child = new FileStore<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.fileStore = child;
		return (T) this;
	}

	/**
	 * The cache file store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T fileStore() {
		FileStore<? extends FileStore> child = new FileStore<>();
		this.subresources.fileStore = child;
		return (T) this;
	}

	/**
	 * The cache file store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T fileStore(FileStoreSupplier supplier) {
		this.subresources.fileStore = supplier.get();
		return (T) this;
	}

	/**
	 * A store-less configuration.
	 */
	@SuppressWarnings("unchecked")
	public T noneStore(NoneStore value) {
		this.subresources.noneStore = value;
		return (T) this;
	}

	/**
	 * A store-less configuration.
	 */
	@SuppressWarnings("unchecked")
	public T noneStore(NoneStoreConsumer consumer) {
		NoneStore<? extends NoneStore> child = new NoneStore<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.noneStore = child;
		return (T) this;
	}

	/**
	 * A store-less configuration.
	 */
	@SuppressWarnings("unchecked")
	public T noneStore() {
		NoneStore<? extends NoneStore> child = new NoneStore<>();
		this.subresources.noneStore = child;
		return (T) this;
	}

	/**
	 * A store-less configuration.
	 */
	@SuppressWarnings("unchecked")
	public T noneStore(NoneStoreSupplier supplier) {
		this.subresources.noneStore = supplier.get();
		return (T) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T transactionComponent(TransactionComponent value) {
		this.subresources.transactionComponent = value;
		return (T) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T transactionComponent(TransactionComponentConsumer consumer) {
		TransactionComponent<? extends TransactionComponent> child = new TransactionComponent<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.transactionComponent = child;
		return (T) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T transactionComponent() {
		TransactionComponent<? extends TransactionComponent> child = new TransactionComponent<>();
		this.subresources.transactionComponent = child;
		return (T) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T transactionComponent(TransactionComponentSupplier supplier) {
		this.subresources.transactionComponent = supplier.get();
		return (T) this;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@SuppressWarnings("unchecked")
	public T lockingComponent(LockingComponent value) {
		this.subresources.lockingComponent = value;
		return (T) this;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@SuppressWarnings("unchecked")
	public T lockingComponent(LockingComponentConsumer consumer) {
		LockingComponent<? extends LockingComponent> child = new LockingComponent<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.lockingComponent = child;
		return (T) this;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@SuppressWarnings("unchecked")
	public T lockingComponent() {
		LockingComponent<? extends LockingComponent> child = new LockingComponent<>();
		this.subresources.lockingComponent = child;
		return (T) this;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@SuppressWarnings("unchecked")
	public T lockingComponent(LockingComponentSupplier supplier) {
		this.subresources.lockingComponent = supplier.get();
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T binaryJdbcStore(BinaryJDBCStore value) {
		this.subresources.binaryJdbcStore = value;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T binaryJdbcStore(BinaryJDBCStoreConsumer consumer) {
		BinaryJDBCStore<? extends BinaryJDBCStore> child = new BinaryJDBCStore<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.binaryJdbcStore = child;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T binaryJdbcStore() {
		BinaryJDBCStore<? extends BinaryJDBCStore> child = new BinaryJDBCStore<>();
		this.subresources.binaryJdbcStore = child;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T binaryJdbcStore(BinaryJDBCStoreSupplier supplier) {
		this.subresources.binaryJdbcStore = supplier.get();
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T mixedJdbcStore(MixedJDBCStore value) {
		this.subresources.mixedJdbcStore = value;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T mixedJdbcStore(MixedJDBCStoreConsumer consumer) {
		MixedJDBCStore<? extends MixedJDBCStore> child = new MixedJDBCStore<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.mixedJdbcStore = child;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T mixedJdbcStore() {
		MixedJDBCStore<? extends MixedJDBCStore> child = new MixedJDBCStore<>();
		this.subresources.mixedJdbcStore = child;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T mixedJdbcStore(MixedJDBCStoreSupplier supplier) {
		this.subresources.mixedJdbcStore = supplier.get();
		return (T) this;
	}

	/**
	 * The cache remote store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T remoteStore(RemoteStore value) {
		this.subresources.remoteStore = value;
		return (T) this;
	}

	/**
	 * The cache remote store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T remoteStore(RemoteStoreConsumer consumer) {
		RemoteStore<? extends RemoteStore> child = new RemoteStore<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.remoteStore = child;
		return (T) this;
	}

	/**
	 * The cache remote store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T remoteStore() {
		RemoteStore<? extends RemoteStore> child = new RemoteStore<>();
		this.subresources.remoteStore = child;
		return (T) this;
	}

	/**
	 * The cache remote store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T remoteStore(RemoteStoreSupplier supplier) {
		this.subresources.remoteStore = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for LocalCache
	 */
	public static class LocalCacheResources {
		private EvictionComponent evictionComponent;
		private StringJDBCStore stringJdbcStore;
		private ExpirationComponent expirationComponent;
		private CustomStore customStore;
		private FileStore fileStore;
		private NoneStore noneStore;
		private TransactionComponent transactionComponent;
		private LockingComponent lockingComponent;
		private BinaryJDBCStore binaryJdbcStore;
		private MixedJDBCStore mixedJdbcStore;
		private RemoteStore remoteStore;

		/**
		 * The cache eviction configuration.
		 */
		@Subresource
		public EvictionComponent evictionComponent() {
			return this.evictionComponent;
		}

		/**
		 * The cache JDBC store configuration.
		 */
		@Subresource
		public StringJDBCStore stringJdbcStore() {
			return this.stringJdbcStore;
		}

		/**
		 * The cache expiration configuration.
		 */
		@Subresource
		public ExpirationComponent expirationComponent() {
			return this.expirationComponent;
		}

		/**
		 * The cache store configuration.
		 */
		@Subresource
		public CustomStore customStore() {
			return this.customStore;
		}

		/**
		 * The cache file store configuration.
		 */
		@Subresource
		public FileStore fileStore() {
			return this.fileStore;
		}

		/**
		 * A store-less configuration.
		 */
		@Subresource
		public NoneStore noneStore() {
			return this.noneStore;
		}

		/**
		 * The cache transaction configuration.
		 */
		@Subresource
		public TransactionComponent transactionComponent() {
			return this.transactionComponent;
		}

		/**
		 * The locking configuration of the cache.
		 */
		@Subresource
		public LockingComponent lockingComponent() {
			return this.lockingComponent;
		}

		/**
		 * The cache JDBC store configuration.
		 */
		@Subresource
		public BinaryJDBCStore binaryJdbcStore() {
			return this.binaryJdbcStore;
		}

		/**
		 * The cache JDBC store configuration.
		 */
		@Subresource
		public MixedJDBCStore mixedJdbcStore() {
			return this.mixedJdbcStore;
		}

		/**
		 * The cache remote store configuration.
		 */
		@Subresource
		public RemoteStore remoteStore() {
			return this.remoteStore;
		}
	}

	/**
	 * The number of cache node activations (bringing a node into memory from a
	 * cache store) . May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "activations")
	public Long activations() {
		return this.activations;
	}

	/**
	 * The number of cache node activations (bringing a node into memory from a
	 * cache store) . May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T activations(Long value) {
		Object oldValue = this.activations;
		this.activations = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("activations", oldValue, value);
		return (T) this;
	}

	/**
	 * Average time (in ms) for cache reads. Includes hits and misses. May
	 * return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "average-read-time")
	public Long averageReadTime() {
		return this.averageReadTime;
	}

	/**
	 * Average time (in ms) for cache reads. Includes hits and misses. May
	 * return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T averageReadTime(Long value) {
		Object oldValue = this.averageReadTime;
		this.averageReadTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("averageReadTime", oldValue, value);
		return (T) this;
	}

	/**
	 * Average time (in ms) for cache writes. May return null if the cache is
	 * not started.
	 */
	@ModelNodeBinding(detypedName = "average-write-time")
	public Long averageWriteTime() {
		return this.averageWriteTime;
	}

	/**
	 * Average time (in ms) for cache writes. May return null if the cache is
	 * not started.
	 */
	@SuppressWarnings("unchecked")
	public T averageWriteTime(Long value) {
		Object oldValue = this.averageWriteTime;
		this.averageWriteTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("averageWriteTime", oldValue, value);
		return (T) this;
	}

	/**
	 * The status of the cache component. May return null if the cache is not
	 * started.
	 */
	@ModelNodeBinding(detypedName = "cache-status")
	public String cacheStatus() {
		return this.cacheStatus;
	}

	/**
	 * The status of the cache component. May return null if the cache is not
	 * started.
	 */
	@SuppressWarnings("unchecked")
	public T cacheStatus(String value) {
		Object oldValue = this.cacheStatus;
		this.cacheStatus = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cacheStatus", oldValue, value);
		return (T) this;
	}

	/**
	 * Time (in secs) since cache started. May return null if the cache is not
	 * started.
	 */
	@ModelNodeBinding(detypedName = "elapsed-time")
	public Long elapsedTime() {
		return this.elapsedTime;
	}

	/**
	 * Time (in secs) since cache started. May return null if the cache is not
	 * started.
	 */
	@SuppressWarnings("unchecked")
	public T elapsedTime(Long value) {
		Object oldValue = this.elapsedTime;
		this.elapsedTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("elapsedTime", oldValue, value);
		return (T) this;
	}

	/**
	 * The hit/miss ratio for the cache (hits/hits+misses). May return null if
	 * the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "hit-ratio")
	public Double hitRatio() {
		return this.hitRatio;
	}

	/**
	 * The hit/miss ratio for the cache (hits/hits+misses). May return null if
	 * the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T hitRatio(Double value) {
		Object oldValue = this.hitRatio;
		this.hitRatio = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("hitRatio", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache attribute hits. May return null if the cache is not
	 * started.
	 */
	@ModelNodeBinding(detypedName = "hits")
	public Long hits() {
		return this.hits;
	}

	/**
	 * The number of cache attribute hits. May return null if the cache is not
	 * started.
	 */
	@SuppressWarnings("unchecked")
	public T hits(Long value) {
		Object oldValue = this.hits;
		this.hits = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("hits", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache invalidations. May return null if the cache is not
	 * started.
	 */
	@ModelNodeBinding(detypedName = "invalidations")
	public Long invalidations() {
		return this.invalidations;
	}

	/**
	 * The number of cache invalidations. May return null if the cache is not
	 * started.
	 */
	@SuppressWarnings("unchecked")
	public T invalidations(Long value) {
		Object oldValue = this.invalidations;
		this.invalidations = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("invalidations", oldValue, value);
		return (T) this;
	}

	/**
	 * The jndi-name to which to bind this cache instance.
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * The jndi-name to which to bind this cache instance.
	 */
	@SuppressWarnings("unchecked")
	public T jndiName(String value) {
		Object oldValue = this.jndiName;
		this.jndiName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jndiName", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache attribute misses. May return null if the cache is not
	 * started.
	 */
	@ModelNodeBinding(detypedName = "misses")
	public Long misses() {
		return this.misses;
	}

	/**
	 * The number of cache attribute misses. May return null if the cache is not
	 * started.
	 */
	@SuppressWarnings("unchecked")
	public T misses(Long value) {
		Object oldValue = this.misses;
		this.misses = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("misses", oldValue, value);
		return (T) this;
	}

	/**
	 * The module whose class loader should be used when building this cache's
	 * configuration.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * The module whose class loader should be used when building this cache's
	 * configuration.
	 */
	@SuppressWarnings("unchecked")
	public T module(String value) {
		Object oldValue = this.module;
		this.module = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("module", oldValue, value);
		return (T) this;
	}

	/**
	 * The current number of entries in the cache. May return null if the cache
	 * is not started.
	 */
	@ModelNodeBinding(detypedName = "number-of-entries")
	public Integer numberOfEntries() {
		return this.numberOfEntries;
	}

	/**
	 * The current number of entries in the cache. May return null if the cache
	 * is not started.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfEntries(Integer value) {
		Object oldValue = this.numberOfEntries;
		this.numberOfEntries = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberOfEntries", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache node passivations (passivating a node from memory to
	 * a cache store). May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "passivations")
	public Long passivations() {
		return this.passivations;
	}

	/**
	 * The number of cache node passivations (passivating a node from memory to
	 * a cache store). May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T passivations(Long value) {
		Object oldValue = this.passivations;
		this.passivations = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("passivations", oldValue, value);
		return (T) this;
	}

	/**
	 * The read/write ratio of the cache ((hits+misses)/stores). May return null
	 * if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "read-write-ratio")
	public Double readWriteRatio() {
		return this.readWriteRatio;
	}

	/**
	 * The read/write ratio of the cache ((hits+misses)/stores). May return null
	 * if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T readWriteRatio(Double value) {
		Object oldValue = this.readWriteRatio;
		this.readWriteRatio = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("readWriteRatio", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache attribute remove hits. May return null if the cache
	 * is not started.
	 */
	@ModelNodeBinding(detypedName = "remove-hits")
	public Long removeHits() {
		return this.removeHits;
	}

	/**
	 * The number of cache attribute remove hits. May return null if the cache
	 * is not started.
	 */
	@SuppressWarnings("unchecked")
	public T removeHits(Long value) {
		Object oldValue = this.removeHits;
		this.removeHits = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("removeHits", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache attribute remove misses. May return null if the cache
	 * is not started.
	 */
	@ModelNodeBinding(detypedName = "remove-misses")
	public Long removeMisses() {
		return this.removeMisses;
	}

	/**
	 * The number of cache attribute remove misses. May return null if the cache
	 * is not started.
	 */
	@SuppressWarnings("unchecked")
	public T removeMisses(Long value) {
		Object oldValue = this.removeMisses;
		this.removeMisses = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("removeMisses", oldValue, value);
		return (T) this;
	}

	/**
	 * If enabled, statistics will be collected for this cache
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * If enabled, statistics will be collected for this cache
	 */
	@SuppressWarnings("unchecked")
	public T statisticsEnabled(Boolean value) {
		Object oldValue = this.statisticsEnabled;
		this.statisticsEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache attribute put operations. May return null if the
	 * cache is not started.
	 */
	@ModelNodeBinding(detypedName = "stores")
	public Long stores() {
		return this.stores;
	}

	/**
	 * The number of cache attribute put operations. May return null if the
	 * cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T stores(Long value) {
		Object oldValue = this.stores;
		this.stores = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("stores", oldValue, value);
		return (T) this;
	}

	/**
	 * Time (in secs) since cache statistics were reset. May return null if the
	 * cache is not started.
	 */
	@ModelNodeBinding(detypedName = "time-since-reset")
	public Long timeSinceReset() {
		return this.timeSinceReset;
	}

	/**
	 * Time (in secs) since cache statistics were reset. May return null if the
	 * cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T timeSinceReset(Long value) {
		Object oldValue = this.timeSinceReset;
		this.timeSinceReset = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("timeSinceReset", oldValue, value);
		return (T) this;
	}
}