package org.wildfly.swarm.config.management.access.role_mapping;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import org.wildfly.swarm.config.management.core.service.Type;
/**
 * An individual principal used within a role mapping.
 */
@Address("/core-service=management/access=authorization/role-mapping=*/exclude=*")
@ResourceType("exclude")
public class Exclude<T extends Exclude<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String name;
	private String realm;
	private Type type;

	public Exclude(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The name of the user or group being mapped.
	 */
	@ModelNodeBinding(detypedName = "name")
	public String name() {
		return this.name;
	}

	/**
	 * The name of the user or group being mapped.
	 */
	@SuppressWarnings("unchecked")
	public T name(String value) {
		Object oldValue = this.name;
		this.name = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("name", oldValue, value);
		return (T) this;
	}

	/**
	 * An optional attribute to map based on the realm used for authentication.
	 */
	@ModelNodeBinding(detypedName = "realm")
	public String realm() {
		return this.realm;
	}

	/**
	 * An optional attribute to map based on the realm used for authentication.
	 */
	@SuppressWarnings("unchecked")
	public T realm(String value) {
		Object oldValue = this.realm;
		this.realm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("realm", oldValue, value);
		return (T) this;
	}

	/**
	 * The type of the Principal being mapped, either 'group' or 'user'.
	 */
	@ModelNodeBinding(detypedName = "type")
	public Type type() {
		return this.type;
	}

	/**
	 * The type of the Principal being mapped, either 'group' or 'user'.
	 */
	@SuppressWarnings("unchecked")
	public T type(Type value) {
		Object oldValue = this.type;
		this.type = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("type", oldValue, value);
		return (T) this;
	}
}