package org.wildfly.swarm.config.security;

import org.wildfly.swarm.config.security.ClassicVault;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ClassicVaultConsumer<T extends ClassicVault<T>> {

	/**
	 * Configure a pre-constructed instance of ClassicVault resource
	 * 
	 * @parameter Instance of ClassicVault to configure
	 * @return nothing
	 */
	void accept(T value);

	default ClassicVaultConsumer<T> andThen(ClassicVaultConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}