package org.wildfly.swarm.config.undertow;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.configuration.RequestLimitConsumer;
import org.wildfly.swarm.config.undertow.configuration.RequestLimitSupplier;
import org.wildfly.swarm.config.undertow.configuration.RequestLimit;
import org.wildfly.swarm.config.undertow.configuration.ErrorPageConsumer;
import org.wildfly.swarm.config.undertow.configuration.ErrorPageSupplier;
import org.wildfly.swarm.config.undertow.configuration.ErrorPage;
import org.wildfly.swarm.config.undertow.configuration.CustomFilterConsumer;
import org.wildfly.swarm.config.undertow.configuration.CustomFilterSupplier;
import org.wildfly.swarm.config.undertow.configuration.CustomFilter;
import org.wildfly.swarm.config.undertow.configuration.GzipConsumer;
import org.wildfly.swarm.config.undertow.configuration.GzipSupplier;
import org.wildfly.swarm.config.undertow.configuration.Gzip;
import org.wildfly.swarm.config.undertow.configuration.ModClusterConsumer;
import org.wildfly.swarm.config.undertow.configuration.ModClusterSupplier;
import org.wildfly.swarm.config.undertow.configuration.ModCluster;
import org.wildfly.swarm.config.undertow.configuration.ExpressionFilterConsumer;
import org.wildfly.swarm.config.undertow.configuration.ExpressionFilterSupplier;
import org.wildfly.swarm.config.undertow.configuration.ExpressionFilter;
import org.wildfly.swarm.config.undertow.configuration.ResponseHeaderConsumer;
import org.wildfly.swarm.config.undertow.configuration.ResponseHeaderSupplier;
import org.wildfly.swarm.config.undertow.configuration.ResponseHeader;
import org.wildfly.swarm.config.undertow.configuration.RewriteConsumer;
import org.wildfly.swarm.config.undertow.configuration.RewriteSupplier;
import org.wildfly.swarm.config.undertow.configuration.Rewrite;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Undertow filters
 */
@Address("/subsystem=undertow/configuration=filter")
@ResourceType("configuration")
@Implicit
public class FilterConfiguration<T extends FilterConfiguration<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private FilterConfigurationResources subresources = new FilterConfigurationResources();

	public FilterConfiguration() {
		this.key = "filter";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public FilterConfigurationResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all RequestLimit objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of RequestLimit objects.
	 */
	@SuppressWarnings("unchecked")
	public T requestLimits(List<RequestLimit> value) {
		this.subresources.requestLimits = value;
		return (T) this;
	}

	/**
	 * Add the RequestLimit object to the list of subresources
	 * 
	 * @param value
	 *            The RequestLimit to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T requestLimit(RequestLimit value) {
		this.subresources.requestLimits.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a RequestLimit object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RequestLimit resource
	 * @param config
	 *            The RequestLimitConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T requestLimit(String childKey, RequestLimitConsumer consumer) {
		RequestLimit<? extends RequestLimit> child = new RequestLimit<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		requestLimit(child);
		return (T) this;
	}

	/**
	 * Create and configure a RequestLimit object to the list of subresources
	 * 
	 * @param key
	 *            The key for the RequestLimit resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T requestLimit(String childKey) {
		requestLimit(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied RequestLimit object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T requestLimit(RequestLimitSupplier supplier) {
		requestLimit(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ErrorPage objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ErrorPage objects.
	 */
	@SuppressWarnings("unchecked")
	public T errorPages(List<ErrorPage> value) {
		this.subresources.errorPages = value;
		return (T) this;
	}

	/**
	 * Add the ErrorPage object to the list of subresources
	 * 
	 * @param value
	 *            The ErrorPage to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T errorPage(ErrorPage value) {
		this.subresources.errorPages.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ErrorPage object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ErrorPage resource
	 * @param config
	 *            The ErrorPageConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T errorPage(String childKey, ErrorPageConsumer consumer) {
		ErrorPage<? extends ErrorPage> child = new ErrorPage<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		errorPage(child);
		return (T) this;
	}

	/**
	 * Create and configure a ErrorPage object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ErrorPage resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T errorPage(String childKey) {
		errorPage(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ErrorPage object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T errorPage(ErrorPageSupplier supplier) {
		errorPage(supplier.get());
		return (T) this;
	}

	/**
	 * Add all CustomFilter objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CustomFilter objects.
	 */
	@SuppressWarnings("unchecked")
	public T customFilters(List<CustomFilter> value) {
		this.subresources.customFilters = value;
		return (T) this;
	}

	/**
	 * Add the CustomFilter object to the list of subresources
	 * 
	 * @param value
	 *            The CustomFilter to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customFilter(CustomFilter value) {
		this.subresources.customFilters.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CustomFilter object to the list of subresources
	 * 
	 * @param key
	 *            The key for the CustomFilter resource
	 * @param config
	 *            The CustomFilterConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customFilter(String childKey, CustomFilterConsumer consumer) {
		CustomFilter<? extends CustomFilter> child = new CustomFilter<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		customFilter(child);
		return (T) this;
	}

	/**
	 * Create and configure a CustomFilter object to the list of subresources
	 * 
	 * @param key
	 *            The key for the CustomFilter resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T customFilter(String childKey) {
		customFilter(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CustomFilter object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T customFilter(CustomFilterSupplier supplier) {
		customFilter(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Gzip objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Gzip objects.
	 */
	@SuppressWarnings("unchecked")
	public T gzips(List<Gzip> value) {
		this.subresources.gzips = value;
		return (T) this;
	}

	/**
	 * Add the Gzip object to the list of subresources
	 * 
	 * @param value
	 *            The Gzip to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T gzip(Gzip value) {
		this.subresources.gzips.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Gzip object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Gzip resource
	 * @param config
	 *            The GzipConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T gzip(String childKey, GzipConsumer consumer) {
		Gzip<? extends Gzip> child = new Gzip<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		gzip(child);
		return (T) this;
	}

	/**
	 * Create and configure a Gzip object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Gzip resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T gzip(String childKey) {
		gzip(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Gzip object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T gzip(GzipSupplier supplier) {
		gzip(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ModCluster objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ModCluster objects.
	 */
	@SuppressWarnings("unchecked")
	public T modClusters(List<ModCluster> value) {
		this.subresources.modClusters = value;
		return (T) this;
	}

	/**
	 * Add the ModCluster object to the list of subresources
	 * 
	 * @param value
	 *            The ModCluster to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T modCluster(ModCluster value) {
		this.subresources.modClusters.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ModCluster object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ModCluster resource
	 * @param config
	 *            The ModClusterConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T modCluster(String childKey, ModClusterConsumer consumer) {
		ModCluster<? extends ModCluster> child = new ModCluster<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		modCluster(child);
		return (T) this;
	}

	/**
	 * Create and configure a ModCluster object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ModCluster resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T modCluster(String childKey) {
		modCluster(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ModCluster object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T modCluster(ModClusterSupplier supplier) {
		modCluster(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ExpressionFilter objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ExpressionFilter objects.
	 */
	@SuppressWarnings("unchecked")
	public T expressionFilters(List<ExpressionFilter> value) {
		this.subresources.expressionFilters = value;
		return (T) this;
	}

	/**
	 * Add the ExpressionFilter object to the list of subresources
	 * 
	 * @param value
	 *            The ExpressionFilter to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T expressionFilter(ExpressionFilter value) {
		this.subresources.expressionFilters.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ExpressionFilter object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ExpressionFilter resource
	 * @param config
	 *            The ExpressionFilterConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T expressionFilter(String childKey, ExpressionFilterConsumer consumer) {
		ExpressionFilter<? extends ExpressionFilter> child = new ExpressionFilter<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		expressionFilter(child);
		return (T) this;
	}

	/**
	 * Create and configure a ExpressionFilter object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ExpressionFilter resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T expressionFilter(String childKey) {
		expressionFilter(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ExpressionFilter object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T expressionFilter(ExpressionFilterSupplier supplier) {
		expressionFilter(supplier.get());
		return (T) this;
	}

	/**
	 * Add all ResponseHeader objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ResponseHeader objects.
	 */
	@SuppressWarnings("unchecked")
	public T responseHeaders(List<ResponseHeader> value) {
		this.subresources.responseHeaders = value;
		return (T) this;
	}

	/**
	 * Add the ResponseHeader object to the list of subresources
	 * 
	 * @param value
	 *            The ResponseHeader to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T responseHeader(ResponseHeader value) {
		this.subresources.responseHeaders.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ResponseHeader object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ResponseHeader resource
	 * @param config
	 *            The ResponseHeaderConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T responseHeader(String childKey, ResponseHeaderConsumer consumer) {
		ResponseHeader<? extends ResponseHeader> child = new ResponseHeader<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		responseHeader(child);
		return (T) this;
	}

	/**
	 * Create and configure a ResponseHeader object to the list of subresources
	 * 
	 * @param key
	 *            The key for the ResponseHeader resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T responseHeader(String childKey) {
		responseHeader(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ResponseHeader object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T responseHeader(ResponseHeaderSupplier supplier) {
		responseHeader(supplier.get());
		return (T) this;
	}

	/**
	 * Add all Rewrite objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Rewrite objects.
	 */
	@SuppressWarnings("unchecked")
	public T rewrites(List<Rewrite> value) {
		this.subresources.rewrites = value;
		return (T) this;
	}

	/**
	 * Add the Rewrite object to the list of subresources
	 * 
	 * @param value
	 *            The Rewrite to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T rewrite(Rewrite value) {
		this.subresources.rewrites.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Rewrite object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Rewrite resource
	 * @param config
	 *            The RewriteConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T rewrite(String childKey, RewriteConsumer consumer) {
		Rewrite<? extends Rewrite> child = new Rewrite<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		rewrite(child);
		return (T) this;
	}

	/**
	 * Create and configure a Rewrite object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Rewrite resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T rewrite(String childKey) {
		rewrite(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Rewrite object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T rewrite(RewriteSupplier supplier) {
		rewrite(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for FilterConfiguration
	 */
	public static class FilterConfigurationResources {
		/**
		 * Concurrent request limiter handler
		 */
		private List<RequestLimit> requestLimits = new java.util.ArrayList<>();
		/**
		 * The error pages
		 */
		private List<ErrorPage> errorPages = new java.util.ArrayList<>();
		/**
		 * Custom filter
		 */
		private List<CustomFilter> customFilters = new java.util.ArrayList<>();
		/**
		 * Defines gzip filter
		 */
		private List<Gzip> gzips = new java.util.ArrayList<>();
		/**
		 * A mod-cluster front end load balancer
		 */
		private List<ModCluster> modClusters = new java.util.ArrayList<>();
		/**
		 * A filter parsed from the undertow expression language
		 */
		private List<ExpressionFilter> expressionFilters = new java.util.ArrayList<>();
		/**
		 * Response header filter allows you to add custom headers.
		 */
		private List<ResponseHeader> responseHeaders = new java.util.ArrayList<>();
		/**
		 * A rewrite (or redirect) filter
		 */
		private List<Rewrite> rewrites = new java.util.ArrayList<>();

		/**
		 * Get the list of RequestLimit resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<RequestLimit> requestLimits() {
			return this.requestLimits;
		}

		public RequestLimit requestLimit(String key) {
			return this.requestLimits.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ErrorPage resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ErrorPage> errorPages() {
			return this.errorPages;
		}

		public ErrorPage errorPage(String key) {
			return this.errorPages.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of CustomFilter resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CustomFilter> customFilters() {
			return this.customFilters;
		}

		public CustomFilter customFilter(String key) {
			return this.customFilters.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of Gzip resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Gzip> gzips() {
			return this.gzips;
		}

		public Gzip gzip(String key) {
			return this.gzips.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Get the list of ModCluster resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ModCluster> modClusters() {
			return this.modClusters;
		}

		public ModCluster modCluster(String key) {
			return this.modClusters.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ExpressionFilter resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ExpressionFilter> expressionFilters() {
			return this.expressionFilters;
		}

		public ExpressionFilter expressionFilter(String key) {
			return this.expressionFilters.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of ResponseHeader resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ResponseHeader> responseHeaders() {
			return this.responseHeaders;
		}

		public ResponseHeader responseHeader(String key) {
			return this.responseHeaders.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Get the list of Rewrite resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Rewrite> rewrites() {
			return this.rewrites;
		}

		public Rewrite rewrite(String key) {
			return this.rewrites.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
	}
}