/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.management.security_realm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/core-service=management/security-realm=*/server-identity=ssl")
@ResourceType(value="server-identity")
@Implicit
public class SslServerIdentity<T extends SslServerIdentity<T>> {
    private String key = "ssl";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private String alias;
    private List<String> enabledCipherSuites;
    private List<String> enabledProtocols;
    private String keyPassword;
    private String keystorePassword;
    private String keystorePath;
    private String keystoreProvider;
    private String keystoreRelativeTo;
    private String protocol;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="alias")
    public String alias() {
        return this.alias;
    }

    public T alias(String value) {
        String oldValue = this.alias;
        this.alias = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("alias", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enabled-cipher-suites")
    public List<String> enabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public T enabledCipherSuites(List<String> value) {
        List<String> oldValue = this.enabledCipherSuites;
        this.enabledCipherSuites = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enabledCipherSuites", oldValue, value);
        }
        return (T)this;
    }

    public T enabledCipherSuite(String value) {
        if (this.enabledCipherSuites == null) {
            this.enabledCipherSuites = new ArrayList<String>();
        }
        this.enabledCipherSuites.add(value);
        return (T)this;
    }

    public T enabledCipherSuites(String ... args) {
        this.enabledCipherSuites(Arrays.asList(args));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enabled-protocols")
    public List<String> enabledProtocols() {
        return this.enabledProtocols;
    }

    public T enabledProtocols(List<String> value) {
        List<String> oldValue = this.enabledProtocols;
        this.enabledProtocols = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enabledProtocols", oldValue, value);
        }
        return (T)this;
    }

    public T enabledProtocol(String value) {
        if (this.enabledProtocols == null) {
            this.enabledProtocols = new ArrayList<String>();
        }
        this.enabledProtocols.add(value);
        return (T)this;
    }

    public T enabledProtocols(String ... args) {
        this.enabledProtocols(Arrays.asList(args));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="key-password")
    public String keyPassword() {
        return this.keyPassword;
    }

    public T keyPassword(String value) {
        String oldValue = this.keyPassword;
        this.keyPassword = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keyPassword", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="keystore-password")
    public String keystorePassword() {
        return this.keystorePassword;
    }

    public T keystorePassword(String value) {
        String oldValue = this.keystorePassword;
        this.keystorePassword = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keystorePassword", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="keystore-path")
    public String keystorePath() {
        return this.keystorePath;
    }

    public T keystorePath(String value) {
        String oldValue = this.keystorePath;
        this.keystorePath = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keystorePath", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="keystore-provider")
    public String keystoreProvider() {
        return this.keystoreProvider;
    }

    public T keystoreProvider(String value) {
        String oldValue = this.keystoreProvider;
        this.keystoreProvider = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keystoreProvider", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="keystore-relative-to")
    public String keystoreRelativeTo() {
        return this.keystoreRelativeTo;
    }

    public T keystoreRelativeTo(String value) {
        String oldValue = this.keystoreRelativeTo;
        this.keystoreRelativeTo = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("keystoreRelativeTo", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="protocol")
    public String protocol() {
        return this.protocol;
    }

    public T protocol(String value) {
        String oldValue = this.protocol;
        this.protocol = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("protocol", oldValue, value);
        }
        return (T)this;
    }
}

