/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.security;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.ClassicACL;
import org.wildfly.swarm.config.security.security_domain.ClassicACLConsumer;
import org.wildfly.swarm.config.security.security_domain.ClassicACLSupplier;
import org.wildfly.swarm.config.security.security_domain.ClassicAudit;
import org.wildfly.swarm.config.security.security_domain.ClassicAuditConsumer;
import org.wildfly.swarm.config.security.security_domain.ClassicAuditSupplier;
import org.wildfly.swarm.config.security.security_domain.ClassicAuthentication;
import org.wildfly.swarm.config.security.security_domain.ClassicAuthenticationConsumer;
import org.wildfly.swarm.config.security.security_domain.ClassicAuthenticationSupplier;
import org.wildfly.swarm.config.security.security_domain.ClassicAuthorization;
import org.wildfly.swarm.config.security.security_domain.ClassicAuthorizationConsumer;
import org.wildfly.swarm.config.security.security_domain.ClassicAuthorizationSupplier;
import org.wildfly.swarm.config.security.security_domain.ClassicIdentityTrust;
import org.wildfly.swarm.config.security.security_domain.ClassicIdentityTrustConsumer;
import org.wildfly.swarm.config.security.security_domain.ClassicIdentityTrustSupplier;
import org.wildfly.swarm.config.security.security_domain.ClassicJSSE;
import org.wildfly.swarm.config.security.security_domain.ClassicJSSEConsumer;
import org.wildfly.swarm.config.security.security_domain.ClassicJSSESupplier;
import org.wildfly.swarm.config.security.security_domain.ClassicMapping;
import org.wildfly.swarm.config.security.security_domain.ClassicMappingConsumer;
import org.wildfly.swarm.config.security.security_domain.ClassicMappingSupplier;
import org.wildfly.swarm.config.security.security_domain.JaspiAuthentication;
import org.wildfly.swarm.config.security.security_domain.JaspiAuthenticationConsumer;
import org.wildfly.swarm.config.security.security_domain.JaspiAuthenticationSupplier;

@Address(value="/subsystem=security/security-domain=*")
@ResourceType(value="security-domain")
public class SecurityDomain<T extends SecurityDomain<T>> {
    private String key;
    private PropertyChangeSupport pcs;
    private SecurityDomainResources subresources = new SecurityDomainResources();
    private CacheType cacheType;

    public SecurityDomain(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public SecurityDomainResources subresources() {
        return this.subresources;
    }

    public T classicJsse(ClassicJSSE value) {
        this.subresources.classicJsse = value;
        return (T)this;
    }

    public T classicJsse(ClassicJSSEConsumer consumer) {
        ClassicJSSE child = new ClassicJSSE();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.classicJsse = child;
        return (T)this;
    }

    public T classicJsse() {
        ClassicJSSE child = new ClassicJSSE();
        this.subresources.classicJsse = child;
        return (T)this;
    }

    public T classicJsse(ClassicJSSESupplier supplier) {
        this.subresources.classicJsse = supplier.get();
        return (T)this;
    }

    public T classicAuthorization(ClassicAuthorization value) {
        this.subresources.classicAuthorization = value;
        return (T)this;
    }

    public T classicAuthorization(ClassicAuthorizationConsumer consumer) {
        ClassicAuthorization child = new ClassicAuthorization();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.classicAuthorization = child;
        return (T)this;
    }

    public T classicAuthorization() {
        ClassicAuthorization child = new ClassicAuthorization();
        this.subresources.classicAuthorization = child;
        return (T)this;
    }

    public T classicAuthorization(ClassicAuthorizationSupplier supplier) {
        this.subresources.classicAuthorization = supplier.get();
        return (T)this;
    }

    public T classicAudit(ClassicAudit value) {
        this.subresources.classicAudit = value;
        return (T)this;
    }

    public T classicAudit(ClassicAuditConsumer consumer) {
        ClassicAudit child = new ClassicAudit();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.classicAudit = child;
        return (T)this;
    }

    public T classicAudit() {
        ClassicAudit child = new ClassicAudit();
        this.subresources.classicAudit = child;
        return (T)this;
    }

    public T classicAudit(ClassicAuditSupplier supplier) {
        this.subresources.classicAudit = supplier.get();
        return (T)this;
    }

    public T classicAcl(ClassicACL value) {
        this.subresources.classicAcl = value;
        return (T)this;
    }

    public T classicAcl(ClassicACLConsumer consumer) {
        ClassicACL child = new ClassicACL();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.classicAcl = child;
        return (T)this;
    }

    public T classicAcl() {
        ClassicACL child = new ClassicACL();
        this.subresources.classicAcl = child;
        return (T)this;
    }

    public T classicAcl(ClassicACLSupplier supplier) {
        this.subresources.classicAcl = supplier.get();
        return (T)this;
    }

    public T jaspiAuthentication(JaspiAuthentication value) {
        this.subresources.jaspiAuthentication = value;
        return (T)this;
    }

    public T jaspiAuthentication(JaspiAuthenticationConsumer consumer) {
        JaspiAuthentication child = new JaspiAuthentication();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.jaspiAuthentication = child;
        return (T)this;
    }

    public T jaspiAuthentication() {
        JaspiAuthentication child = new JaspiAuthentication();
        this.subresources.jaspiAuthentication = child;
        return (T)this;
    }

    public T jaspiAuthentication(JaspiAuthenticationSupplier supplier) {
        this.subresources.jaspiAuthentication = supplier.get();
        return (T)this;
    }

    public T classicMapping(ClassicMapping value) {
        this.subresources.classicMapping = value;
        return (T)this;
    }

    public T classicMapping(ClassicMappingConsumer consumer) {
        ClassicMapping child = new ClassicMapping();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.classicMapping = child;
        return (T)this;
    }

    public T classicMapping() {
        ClassicMapping child = new ClassicMapping();
        this.subresources.classicMapping = child;
        return (T)this;
    }

    public T classicMapping(ClassicMappingSupplier supplier) {
        this.subresources.classicMapping = supplier.get();
        return (T)this;
    }

    public T classicIdentityTrust(ClassicIdentityTrust value) {
        this.subresources.classicIdentityTrust = value;
        return (T)this;
    }

    public T classicIdentityTrust(ClassicIdentityTrustConsumer consumer) {
        ClassicIdentityTrust child = new ClassicIdentityTrust();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.classicIdentityTrust = child;
        return (T)this;
    }

    public T classicIdentityTrust() {
        ClassicIdentityTrust child = new ClassicIdentityTrust();
        this.subresources.classicIdentityTrust = child;
        return (T)this;
    }

    public T classicIdentityTrust(ClassicIdentityTrustSupplier supplier) {
        this.subresources.classicIdentityTrust = supplier.get();
        return (T)this;
    }

    public T classicAuthentication(ClassicAuthentication value) {
        this.subresources.classicAuthentication = value;
        return (T)this;
    }

    public T classicAuthentication(ClassicAuthenticationConsumer consumer) {
        ClassicAuthentication child = new ClassicAuthentication();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.classicAuthentication = child;
        return (T)this;
    }

    public T classicAuthentication() {
        ClassicAuthentication child = new ClassicAuthentication();
        this.subresources.classicAuthentication = child;
        return (T)this;
    }

    public T classicAuthentication(ClassicAuthenticationSupplier supplier) {
        this.subresources.classicAuthentication = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cache-type")
    public CacheType cacheType() {
        return this.cacheType;
    }

    public T cacheType(CacheType value) {
        CacheType oldValue = this.cacheType;
        this.cacheType = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cacheType", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    public static enum CacheType {
        DEFAULT("default"),
        INFINISPAN("infinispan");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private CacheType(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static class SecurityDomainResources {
        private ClassicJSSE classicJsse;
        private ClassicAuthorization classicAuthorization;
        private ClassicAudit classicAudit;
        private ClassicACL classicAcl;
        private JaspiAuthentication jaspiAuthentication;
        private ClassicMapping classicMapping;
        private ClassicIdentityTrust classicIdentityTrust;
        private ClassicAuthentication classicAuthentication;

        @Subresource
        public ClassicJSSE classicJsse() {
            return this.classicJsse;
        }

        @Subresource
        public ClassicAuthorization classicAuthorization() {
            return this.classicAuthorization;
        }

        @Subresource
        public ClassicAudit classicAudit() {
            return this.classicAudit;
        }

        @Subresource
        public ClassicACL classicAcl() {
            return this.classicAcl;
        }

        @Subresource
        public JaspiAuthentication jaspiAuthentication() {
            return this.jaspiAuthentication;
        }

        @Subresource
        public ClassicMapping classicMapping() {
            return this.classicMapping;
        }

        @Subresource
        public ClassicIdentityTrust classicIdentityTrust() {
            return this.classicIdentityTrust;
        }

        @Subresource
        public ClassicAuthentication classicAuthentication() {
            return this.classicAuthentication;
        }
    }
}

