package org.wildfly.swarm.config;

import org.wildfly.swarm.config.EE;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface EEConsumer<T extends EE<T>> {

	/**
	 * Configure a pre-constructed instance of EE resource
	 * 
	 * @parameter Instance of EE to configure
	 * @return nothing
	 */
	void accept(T value);

	default EEConsumer<T> andThen(EEConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}