package org.wildfly.swarm.config.batch.jberet;

import org.wildfly.swarm.config.batch.jberet.ThreadFactory;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ThreadFactoryConsumer<T extends ThreadFactory<T>> {

	/**
	 * Configure a pre-constructed instance of ThreadFactory resource
	 * 
	 * @parameter Instance of ThreadFactory to configure
	 * @return nothing
	 */
	void accept(T value);

	default ThreadFactoryConsumer<T> andThen(ThreadFactoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}