package org.wildfly.swarm.config.jmx;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The configuration for exposing the 'expression' model controller in the
 * MBeanServer. This facade will expose all simple attributes and operation
 * parameters as String. Reads return the unresolved expression. You may use
 * expressions when writing attributes and setting operation parameters.
 */
@Address("/subsystem=jmx/expose-model=expression")
@ResourceType("expose-model")
@Implicit
public class ExpressionExposeModel<T extends ExpressionExposeModel<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String domainName;

	public ExpressionExposeModel() {
		this.key = "expression";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The domain name to use for the 'expression' model controller JMX facade
	 * in the MBeanServer.
	 */
	@ModelNodeBinding(detypedName = "domain-name")
	public String domainName() {
		return this.domainName;
	}

	/**
	 * The domain name to use for the 'expression' model controller JMX facade
	 * in the MBeanServer.
	 */
	@SuppressWarnings("unchecked")
	public T domainName(String value) {
		Object oldValue = this.domainName;
		this.domainName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("domainName", oldValue, value);
		return (T) this;
	}
}