package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.management.security_realm.UsersAuthentication;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface UsersAuthenticationConsumer<T extends UsersAuthentication<T>> {

	/**
	 * Configure a pre-constructed instance of UsersAuthentication resource
	 * 
	 * @parameter Instance of UsersAuthentication to configure
	 * @return nothing
	 */
	void accept(T value);

	default UsersAuthenticationConsumer<T> andThen(
			UsersAuthenticationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}