package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
/**
 * Defines a JMS topic.
 */
@Address("/subsystem=messaging-activemq/server=*/jms-topic=*")
@ResourceType("jms-topic")
public class JMSTopic<T extends JMSTopic<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private Integer deliveringCount;
	private Integer durableMessageCount;
	private Integer durableSubscriptionCount;
	private List<String> entries;
	private List<String> legacyEntries;
	private Long messageCount;
	private Long messagesAdded;
	private Integer nonDurableMessageCount;
	private Integer nonDurableSubscriptionCount;
	private Integer subscriptionCount;
	private Boolean temporary;
	private String topicAddress;

	public JMSTopic(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The number of messages that this queue is currently delivering to its
	 * consumers.
	 */
	@ModelNodeBinding(detypedName = "delivering-count")
	public Integer deliveringCount() {
		return this.deliveringCount;
	}

	/**
	 * The number of messages that this queue is currently delivering to its
	 * consumers.
	 */
	@SuppressWarnings("unchecked")
	public T deliveringCount(Integer value) {
		Object oldValue = this.deliveringCount;
		this.deliveringCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("deliveringCount", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of messages for all durable subscribers for this topic.
	 */
	@ModelNodeBinding(detypedName = "durable-message-count")
	public Integer durableMessageCount() {
		return this.durableMessageCount;
	}

	/**
	 * The number of messages for all durable subscribers for this topic.
	 */
	@SuppressWarnings("unchecked")
	public T durableMessageCount(Integer value) {
		Object oldValue = this.durableMessageCount;
		this.durableMessageCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("durableMessageCount", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of durable subscribers for this topic.
	 */
	@ModelNodeBinding(detypedName = "durable-subscription-count")
	public Integer durableSubscriptionCount() {
		return this.durableSubscriptionCount;
	}

	/**
	 * The number of durable subscribers for this topic.
	 */
	@SuppressWarnings("unchecked")
	public T durableSubscriptionCount(Integer value) {
		Object oldValue = this.durableSubscriptionCount;
		this.durableSubscriptionCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("durableSubscriptionCount", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The jndi names the topic will be bound to.
	 */
	@ModelNodeBinding(detypedName = "entries")
	public List<String> entries() {
		return this.entries;
	}

	/**
	 * The jndi names the topic will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T entries(List<String> value) {
		Object oldValue = this.entries;
		this.entries = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("entries", oldValue, value);
		return (T) this;
	}

	/**
	 * The jndi names the topic will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T entry(String value) {
		if (this.entries == null) {
			this.entries = new java.util.ArrayList<>();
		}
		this.entries.add(value);
		return (T) this;
	}

	/**
	 * The jndi names the topic will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T entries(String... args) {
		entries(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * The legacy jndi names the topic will be bound to.
	 */
	@ModelNodeBinding(detypedName = "legacy-entries")
	public List<String> legacyEntries() {
		return this.legacyEntries;
	}

	/**
	 * The legacy jndi names the topic will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T legacyEntries(List<String> value) {
		Object oldValue = this.legacyEntries;
		this.legacyEntries = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("legacyEntries", oldValue, value);
		return (T) this;
	}

	/**
	 * The legacy jndi names the topic will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T legacyEntry(String value) {
		if (this.legacyEntries == null) {
			this.legacyEntries = new java.util.ArrayList<>();
		}
		this.legacyEntries.add(value);
		return (T) this;
	}

	/**
	 * The legacy jndi names the topic will be bound to.
	 */
	@SuppressWarnings("unchecked")
	public T legacyEntries(String... args) {
		legacyEntries(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * The number of messages currently in this queue.
	 */
	@ModelNodeBinding(detypedName = "message-count")
	public Long messageCount() {
		return this.messageCount;
	}

	/**
	 * The number of messages currently in this queue.
	 */
	@SuppressWarnings("unchecked")
	public T messageCount(Long value) {
		Object oldValue = this.messageCount;
		this.messageCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("messageCount", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of messages added to this queue since it was created.
	 */
	@ModelNodeBinding(detypedName = "messages-added")
	public Long messagesAdded() {
		return this.messagesAdded;
	}

	/**
	 * The number of messages added to this queue since it was created.
	 */
	@SuppressWarnings("unchecked")
	public T messagesAdded(Long value) {
		Object oldValue = this.messagesAdded;
		this.messagesAdded = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("messagesAdded", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of messages for all non-durable subscribers for this topic.
	 */
	@ModelNodeBinding(detypedName = "non-durable-message-count")
	public Integer nonDurableMessageCount() {
		return this.nonDurableMessageCount;
	}

	/**
	 * The number of messages for all non-durable subscribers for this topic.
	 */
	@SuppressWarnings("unchecked")
	public T nonDurableMessageCount(Integer value) {
		Object oldValue = this.nonDurableMessageCount;
		this.nonDurableMessageCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("nonDurableMessageCount", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The number of non-durable subscribers for this topic.
	 */
	@ModelNodeBinding(detypedName = "non-durable-subscription-count")
	public Integer nonDurableSubscriptionCount() {
		return this.nonDurableSubscriptionCount;
	}

	/**
	 * The number of non-durable subscribers for this topic.
	 */
	@SuppressWarnings("unchecked")
	public T nonDurableSubscriptionCount(Integer value) {
		Object oldValue = this.nonDurableSubscriptionCount;
		this.nonDurableSubscriptionCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("nonDurableSubscriptionCount",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The number of (durable and non-durable) subscribers for this topic.
	 */
	@ModelNodeBinding(detypedName = "subscription-count")
	public Integer subscriptionCount() {
		return this.subscriptionCount;
	}

	/**
	 * The number of (durable and non-durable) subscribers for this topic.
	 */
	@SuppressWarnings("unchecked")
	public T subscriptionCount(Integer value) {
		Object oldValue = this.subscriptionCount;
		this.subscriptionCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("subscriptionCount", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the topic is temporary.
	 */
	@ModelNodeBinding(detypedName = "temporary")
	public Boolean temporary() {
		return this.temporary;
	}

	/**
	 * Whether the topic is temporary.
	 */
	@SuppressWarnings("unchecked")
	public T temporary(Boolean value) {
		Object oldValue = this.temporary;
		this.temporary = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("temporary", oldValue, value);
		return (T) this;
	}

	/**
	 * The address the topic points to.
	 */
	@ModelNodeBinding(detypedName = "topic-address")
	public String topicAddress() {
		return this.topicAddress;
	}

	/**
	 * The address the topic points to.
	 */
	@SuppressWarnings("unchecked")
	public T topicAddress(String value) {
		Object oldValue = this.topicAddress;
		this.topicAddress = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("topicAddress", oldValue, value);
		return (T) this;
	}
}