package org.wildfly.swarm.config.remoting;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Endpoint configuration
 */
@Address("/subsystem=remoting/configuration=endpoint")
@ResourceType("configuration")
@Implicit
public class EndpointConfiguration<T extends EndpointConfiguration<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String authRealm;
	private Integer authenticationRetries;
	private String authorizeId;
	private Integer bufferRegionSize;
	private Integer heartbeatInterval;
	private Integer maxInboundChannels;
	private Long maxInboundMessageSize;
	private Integer maxInboundMessages;
	private Integer maxOutboundChannels;
	private Long maxOutboundMessageSize;
	private Integer maxOutboundMessages;
	private Integer receiveBufferSize;
	private Integer receiveWindowSize;
	private String saslProtocol;
	private Integer sendBufferSize;
	private String serverName;
	private Integer transmitWindowSize;
	private String worker;

	public EndpointConfiguration() {
		this.key = "endpoint";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The authentication realm to use if no authentication
	 * {@code CallbackHandler} is specified.
	 */
	@ModelNodeBinding(detypedName = "auth-realm")
	public String authRealm() {
		return this.authRealm;
	}

	/**
	 * The authentication realm to use if no authentication
	 * {@code CallbackHandler} is specified.
	 */
	@SuppressWarnings("unchecked")
	public T authRealm(String value) {
		Object oldValue = this.authRealm;
		this.authRealm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("authRealm", oldValue, value);
		return (T) this;
	}

	/**
	 * Specify the number of times a client is allowed to retry authentication
	 * before closing the connection.
	 */
	@ModelNodeBinding(detypedName = "authentication-retries")
	public Integer authenticationRetries() {
		return this.authenticationRetries;
	}

	/**
	 * Specify the number of times a client is allowed to retry authentication
	 * before closing the connection.
	 */
	@SuppressWarnings("unchecked")
	public T authenticationRetries(Integer value) {
		Object oldValue = this.authenticationRetries;
		this.authenticationRetries = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("authenticationRetries", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The SASL authorization ID. Used as authentication user name to use if no
	 * authentication {@code CallbackHandler} is specifiedand the selected SASL
	 * mechanism demands a user name.
	 */
	@ModelNodeBinding(detypedName = "authorize-id")
	public String authorizeId() {
		return this.authorizeId;
	}

	/**
	 * The SASL authorization ID. Used as authentication user name to use if no
	 * authentication {@code CallbackHandler} is specifiedand the selected SASL
	 * mechanism demands a user name.
	 */
	@SuppressWarnings("unchecked")
	public T authorizeId(String value) {
		Object oldValue = this.authorizeId;
		this.authorizeId = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("authorizeId", oldValue, value);
		return (T) this;
	}

	/**
	 * The size of allocated buffer regions.
	 */
	@ModelNodeBinding(detypedName = "buffer-region-size")
	public Integer bufferRegionSize() {
		return this.bufferRegionSize;
	}

	/**
	 * The size of allocated buffer regions.
	 */
	@SuppressWarnings("unchecked")
	public T bufferRegionSize(Integer value) {
		Object oldValue = this.bufferRegionSize;
		this.bufferRegionSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("bufferRegionSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The interval to use for connection heartbeat, in milliseconds. If the
	 * connection is idle in the outbound directionfor this amount of time, a
	 * ping message will be sent, which will trigger a corresponding reply
	 * message.
	 */
	@ModelNodeBinding(detypedName = "heartbeat-interval")
	public Integer heartbeatInterval() {
		return this.heartbeatInterval;
	}

	/**
	 * The interval to use for connection heartbeat, in milliseconds. If the
	 * connection is idle in the outbound directionfor this amount of time, a
	 * ping message will be sent, which will trigger a corresponding reply
	 * message.
	 */
	@SuppressWarnings("unchecked")
	public T heartbeatInterval(Integer value) {
		Object oldValue = this.heartbeatInterval;
		this.heartbeatInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("heartbeatInterval", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of concurrent inbound messages on a channel.
	 */
	@ModelNodeBinding(detypedName = "max-inbound-channels")
	public Integer maxInboundChannels() {
		return this.maxInboundChannels;
	}

	/**
	 * The maximum number of concurrent inbound messages on a channel.
	 */
	@SuppressWarnings("unchecked")
	public T maxInboundChannels(Integer value) {
		Object oldValue = this.maxInboundChannels;
		this.maxInboundChannels = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxInboundChannels", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum inbound message size to be allowed. Messages exceeding this
	 * size will cause an exception to be thrown on the reading side as well as
	 * the writing side.
	 */
	@ModelNodeBinding(detypedName = "max-inbound-message-size")
	public Long maxInboundMessageSize() {
		return this.maxInboundMessageSize;
	}

	/**
	 * The maximum inbound message size to be allowed. Messages exceeding this
	 * size will cause an exception to be thrown on the reading side as well as
	 * the writing side.
	 */
	@SuppressWarnings("unchecked")
	public T maxInboundMessageSize(Long value) {
		Object oldValue = this.maxInboundMessageSize;
		this.maxInboundMessageSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxInboundMessageSize", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The maximum number of inbound channels to support for a connection.
	 */
	@ModelNodeBinding(detypedName = "max-inbound-messages")
	public Integer maxInboundMessages() {
		return this.maxInboundMessages;
	}

	/**
	 * The maximum number of inbound channels to support for a connection.
	 */
	@SuppressWarnings("unchecked")
	public T maxInboundMessages(Integer value) {
		Object oldValue = this.maxInboundMessages;
		this.maxInboundMessages = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxInboundMessages", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum number of concurrent outbound messages on a channel.
	 */
	@ModelNodeBinding(detypedName = "max-outbound-channels")
	public Integer maxOutboundChannels() {
		return this.maxOutboundChannels;
	}

	/**
	 * The maximum number of concurrent outbound messages on a channel.
	 */
	@SuppressWarnings("unchecked")
	public T maxOutboundChannels(Integer value) {
		Object oldValue = this.maxOutboundChannels;
		this.maxOutboundChannels = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxOutboundChannels", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum outbound message size to send. No messages larger than this
	 * well be transmitted; attempting to do so will cause an exception on the
	 * writing side.
	 */
	@ModelNodeBinding(detypedName = "max-outbound-message-size")
	public Long maxOutboundMessageSize() {
		return this.maxOutboundMessageSize;
	}

	/**
	 * The maximum outbound message size to send. No messages larger than this
	 * well be transmitted; attempting to do so will cause an exception on the
	 * writing side.
	 */
	@SuppressWarnings("unchecked")
	public T maxOutboundMessageSize(Long value) {
		Object oldValue = this.maxOutboundMessageSize;
		this.maxOutboundMessageSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxOutboundMessageSize", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The maximum number of outbound channels to support for a connection.
	 */
	@ModelNodeBinding(detypedName = "max-outbound-messages")
	public Integer maxOutboundMessages() {
		return this.maxOutboundMessages;
	}

	/**
	 * The maximum number of outbound channels to support for a connection.
	 */
	@SuppressWarnings("unchecked")
	public T maxOutboundMessages(Integer value) {
		Object oldValue = this.maxOutboundMessages;
		this.maxOutboundMessages = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxOutboundMessages", oldValue, value);
		return (T) this;
	}

	/**
	 * The size of the largest buffer that this endpoint will accept over a
	 * connection.
	 */
	@ModelNodeBinding(detypedName = "receive-buffer-size")
	public Integer receiveBufferSize() {
		return this.receiveBufferSize;
	}

	/**
	 * The size of the largest buffer that this endpoint will accept over a
	 * connection.
	 */
	@SuppressWarnings("unchecked")
	public T receiveBufferSize(Integer value) {
		Object oldValue = this.receiveBufferSize;
		this.receiveBufferSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("receiveBufferSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum window size of the receive direction for connection channels,
	 * in bytes.
	 */
	@ModelNodeBinding(detypedName = "receive-window-size")
	public Integer receiveWindowSize() {
		return this.receiveWindowSize;
	}

	/**
	 * The maximum window size of the receive direction for connection channels,
	 * in bytes.
	 */
	@SuppressWarnings("unchecked")
	public T receiveWindowSize(Integer value) {
		Object oldValue = this.receiveWindowSize;
		this.receiveWindowSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("receiveWindowSize", oldValue, value);
		return (T) this;
	}

	/**
	 * Where a SaslServer or SaslClient are created by default the protocol
	 * specified it 'remoting', this can be used to override this.
	 */
	@ModelNodeBinding(detypedName = "sasl-protocol")
	public String saslProtocol() {
		return this.saslProtocol;
	}

	/**
	 * Where a SaslServer or SaslClient are created by default the protocol
	 * specified it 'remoting', this can be used to override this.
	 */
	@SuppressWarnings("unchecked")
	public T saslProtocol(String value) {
		Object oldValue = this.saslProtocol;
		this.saslProtocol = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("saslProtocol", oldValue, value);
		return (T) this;
	}

	/**
	 * The size of the largest buffer that this endpoint will transmit over a
	 * connection.
	 */
	@ModelNodeBinding(detypedName = "send-buffer-size")
	public Integer sendBufferSize() {
		return this.sendBufferSize;
	}

	/**
	 * The size of the largest buffer that this endpoint will transmit over a
	 * connection.
	 */
	@SuppressWarnings("unchecked")
	public T sendBufferSize(Integer value) {
		Object oldValue = this.sendBufferSize;
		this.sendBufferSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sendBufferSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The server side of the connection passes it's name to the client in the
	 * initial greeting, by default the name is automatically discovered from
	 * the local address of the connection or it can be overridden using this.
	 */
	@ModelNodeBinding(detypedName = "server-name")
	public String serverName() {
		return this.serverName;
	}

	/**
	 * The server side of the connection passes it's name to the client in the
	 * initial greeting, by default the name is automatically discovered from
	 * the local address of the connection or it can be overridden using this.
	 */
	@SuppressWarnings("unchecked")
	public T serverName(String value) {
		Object oldValue = this.serverName;
		this.serverName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("serverName", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum window size of the transmit direction for connection
	 * channels, in bytes.
	 */
	@ModelNodeBinding(detypedName = "transmit-window-size")
	public Integer transmitWindowSize() {
		return this.transmitWindowSize;
	}

	/**
	 * The maximum window size of the transmit direction for connection
	 * channels, in bytes.
	 */
	@SuppressWarnings("unchecked")
	public T transmitWindowSize(Integer value) {
		Object oldValue = this.transmitWindowSize;
		this.transmitWindowSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("transmitWindowSize", oldValue, value);
		return (T) this;
	}

	/**
	 * Worker to use
	 */
	@ModelNodeBinding(detypedName = "worker")
	public String worker() {
		return this.worker;
	}

	/**
	 * Worker to use
	 */
	@SuppressWarnings("unchecked")
	public T worker(String value) {
		Object oldValue = this.worker;
		this.worker = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("worker", oldValue, value);
		return (T) this;
	}
}