package org.wildfly.swarm.config.resource.adapters.resource_adapter;

import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A custom defined config property.
 */
@Addresses({
		"/subsystem=resource-adapters/resource-adapter=*/config-properties=*",
		"/subsystem=resource-adapters/resource-adapter=*/admin-objects=*/config-properties=*",
		"/subsystem=resource-adapters/resource-adapter=*/connection-definitions=*/config-properties=*"})
@ResourceType("config-properties")
public class ConfigProperties<T extends ConfigProperties<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String value;

	public ConfigProperties(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Custom defined config property value.
	 */
	@ModelNodeBinding(detypedName = "value")
	public String value() {
		return this.value;
	}

	/**
	 * Custom defined config property value.
	 */
	@SuppressWarnings("unchecked")
	public T value(String value) {
		Object oldValue = this.value;
		this.value = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("value", oldValue, value);
		return (T) this;
	}
}