package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Concurrent request limiter handler
 */
@Address("/subsystem=undertow/configuration=filter/request-limit=*")
@ResourceType("request-limit")
public class RequestLimit<T extends RequestLimit<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private Integer maxConcurrentRequests;
	private Integer queueSize;

	public RequestLimit(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Maximum number of concurrent requests
	 */
	@ModelNodeBinding(detypedName = "max-concurrent-requests")
	public Integer maxConcurrentRequests() {
		return this.maxConcurrentRequests;
	}

	/**
	 * Maximum number of concurrent requests
	 */
	@SuppressWarnings("unchecked")
	public T maxConcurrentRequests(Integer value) {
		Object oldValue = this.maxConcurrentRequests;
		this.maxConcurrentRequests = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxConcurrentRequests", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Number of requests to queue before they start being rejected
	 */
	@ModelNodeBinding(detypedName = "queue-size")
	public Integer queueSize() {
		return this.queueSize;
	}

	/**
	 * Number of requests to queue before they start being rejected
	 */
	@SuppressWarnings("unchecked")
	public T queueSize(Integer value) {
		Object oldValue = this.queueSize;
		this.queueSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("queueSize", oldValue, value);
		return (T) this;
	}
}