/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.webservices.ClientConfig;
import org.wildfly.swarm.config.webservices.ClientConfigConsumer;
import org.wildfly.swarm.config.webservices.ClientConfigSupplier;
import org.wildfly.swarm.config.webservices.EndpointConfig;
import org.wildfly.swarm.config.webservices.EndpointConfigConsumer;
import org.wildfly.swarm.config.webservices.EndpointConfigSupplier;

@Address(value="/subsystem=webservices")
@ResourceType(value="subsystem")
@Implicit
public class Webservices<T extends Webservices<T>> {
    private String key = "webservices";
    private PropertyChangeSupport pcs;
    private WebservicesResources subresources = new WebservicesResources();
    private Boolean modifyWsdlAddress;
    private Boolean statisticsEnabled;
    private String wsdlHost;
    private String wsdlPathRewriteRule;
    private Integer wsdlPort;
    private Integer wsdlSecurePort;
    private WsdlUriScheme wsdlUriScheme;

    public Webservices() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public WebservicesResources subresources() {
        return this.subresources;
    }

    public T clientConfigs(List<ClientConfig> value) {
        this.subresources.clientConfigs = value;
        return (T)this;
    }

    public T clientConfig(ClientConfig value) {
        this.subresources.clientConfigs.add(value);
        return (T)this;
    }

    public T clientConfig(String childKey, ClientConfigConsumer consumer) {
        ClientConfig child = new ClientConfig(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.clientConfig(child);
        return (T)this;
    }

    public T clientConfig(String childKey) {
        this.clientConfig(childKey, null);
        return (T)this;
    }

    public T clientConfig(ClientConfigSupplier supplier) {
        this.clientConfig(supplier.get());
        return (T)this;
    }

    public T endpointConfigs(List<EndpointConfig> value) {
        this.subresources.endpointConfigs = value;
        return (T)this;
    }

    public T endpointConfig(EndpointConfig value) {
        this.subresources.endpointConfigs.add(value);
        return (T)this;
    }

    public T endpointConfig(String childKey, EndpointConfigConsumer consumer) {
        EndpointConfig child = new EndpointConfig(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.endpointConfig(child);
        return (T)this;
    }

    public T endpointConfig(String childKey) {
        this.endpointConfig(childKey, null);
        return (T)this;
    }

    public T endpointConfig(EndpointConfigSupplier supplier) {
        this.endpointConfig(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="modify-wsdl-address")
    public Boolean modifyWsdlAddress() {
        return this.modifyWsdlAddress;
    }

    public T modifyWsdlAddress(Boolean value) {
        Boolean oldValue = this.modifyWsdlAddress;
        this.modifyWsdlAddress = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("modifyWsdlAddress", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="statistics-enabled")
    public Boolean statisticsEnabled() {
        return this.statisticsEnabled;
    }

    public T statisticsEnabled(Boolean value) {
        Boolean oldValue = this.statisticsEnabled;
        this.statisticsEnabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wsdl-host")
    public String wsdlHost() {
        return this.wsdlHost;
    }

    public T wsdlHost(String value) {
        String oldValue = this.wsdlHost;
        this.wsdlHost = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wsdlHost", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wsdl-path-rewrite-rule")
    public String wsdlPathRewriteRule() {
        return this.wsdlPathRewriteRule;
    }

    public T wsdlPathRewriteRule(String value) {
        String oldValue = this.wsdlPathRewriteRule;
        this.wsdlPathRewriteRule = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wsdlPathRewriteRule", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wsdl-port")
    public Integer wsdlPort() {
        return this.wsdlPort;
    }

    public T wsdlPort(Integer value) {
        Integer oldValue = this.wsdlPort;
        this.wsdlPort = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wsdlPort", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wsdl-secure-port")
    public Integer wsdlSecurePort() {
        return this.wsdlSecurePort;
    }

    public T wsdlSecurePort(Integer value) {
        Integer oldValue = this.wsdlSecurePort;
        this.wsdlSecurePort = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wsdlSecurePort", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="wsdl-uri-scheme")
    public WsdlUriScheme wsdlUriScheme() {
        return this.wsdlUriScheme;
    }

    public T wsdlUriScheme(WsdlUriScheme value) {
        WsdlUriScheme oldValue = this.wsdlUriScheme;
        this.wsdlUriScheme = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("wsdlUriScheme", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    public static enum WsdlUriScheme {
        HTTP("http"),
        HTTPS("https");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private WsdlUriScheme(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static class WebservicesResources {
        private List<ClientConfig> clientConfigs = new ArrayList<ClientConfig>();
        private List<EndpointConfig> endpointConfigs = new ArrayList<EndpointConfig>();

        @Subresource
        public List<ClientConfig> clientConfigs() {
            return this.clientConfigs;
        }

        public ClientConfig clientConfig(String key) {
            return this.clientConfigs.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<EndpointConfig> endpointConfigs() {
            return this.endpointConfigs;
        }

        public EndpointConfig endpointConfig(String key) {
            return this.endpointConfigs.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

