package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.datasources.JdbcDriver;
import org.wildfly.swarm.config.datasources.XaDataSource;
import org.wildfly.swarm.config.datasources.DataSource;
/**
 * The data-sources subsystem, used to declare JDBC data-sources
 */
@ResourceType("subsystem")
@Implicit
public class Datasources<T extends Datasources> {

	private String key;
	private List<java.util.Map> installedDrivers;
	private DatasourcesResources subresources = new DatasourcesResources();

	public Datasources() {
		this.key = "datasources";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * List of JDBC drivers that have been installed in the runtime
	 */
	@ModelNodeBinding(detypedName = "installed-drivers")
	public List<Map> installedDrivers() {
		return this.installedDrivers;
	}

	/**
	 * List of JDBC drivers that have been installed in the runtime
	 */
	@SuppressWarnings("unchecked")
	public T installedDrivers(List<java.util.Map> value) {
		this.installedDrivers = value;
		return (T) this;
	}

	public DatasourcesResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.datasources.JdbcDriver objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.datasources.JdbcDriver objects.
	 */
	@SuppressWarnings("unchecked")
	public T jdbcDrivers(
			List<org.wildfly.swarm.config.datasources.JdbcDriver> value) {
		this.subresources.jdbcDrivers.addAll(value);
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.datasources.JdbcDriver object to the list of subresources
	 * @param value The org.wildfly.swarm.config.datasources.JdbcDriver to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T jdbcDriver(JdbcDriver value) {
		this.subresources.jdbcDrivers.add(value);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.datasources.XaDataSource objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.datasources.XaDataSource objects.
	 */
	@SuppressWarnings("unchecked")
	public T xaDataSources(
			List<org.wildfly.swarm.config.datasources.XaDataSource> value) {
		this.subresources.xaDataSources.addAll(value);
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.datasources.XaDataSource object to the list of subresources
	 * @param value The org.wildfly.swarm.config.datasources.XaDataSource to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T xaDataSource(XaDataSource value) {
		this.subresources.xaDataSources.add(value);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.datasources.DataSource objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.datasources.DataSource objects.
	 */
	@SuppressWarnings("unchecked")
	public T dataSources(
			List<org.wildfly.swarm.config.datasources.DataSource> value) {
		this.subresources.dataSources.addAll(value);
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.datasources.DataSource object to the list of subresources
	 * @param value The org.wildfly.swarm.config.datasources.DataSource to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T dataSource(DataSource value) {
		this.subresources.dataSources.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Datasources
	 */
	public class DatasourcesResources {
		/**
		 * Service that make a JDBC driver available for use in the runtime
		 */
		private List<org.wildfly.swarm.config.datasources.JdbcDriver> jdbcDrivers = new java.util.ArrayList<>();
		/**
		 * A JDBC XA data-source configuration
		 */
		private List<org.wildfly.swarm.config.datasources.XaDataSource> xaDataSources = new java.util.ArrayList<>();
		/**
		 * A JDBC data-source configuration
		 */
		private List<org.wildfly.swarm.config.datasources.DataSource> dataSources = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.datasources.JdbcDriver resources
		 * @return the list of resources
		 */
		@Subresource
		public List<JdbcDriver> jdbcDrivers() {
			return this.jdbcDrivers;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.datasources.XaDataSource resources
		 * @return the list of resources
		 */
		@Subresource
		public List<XaDataSource> xaDataSources() {
			return this.xaDataSources;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.datasources.DataSource resources
		 * @return the list of resources
		 */
		@Subresource
		public List<DataSource> dataSources() {
			return this.dataSources;
		}
	}
}