package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.naming.Binding;
import org.wildfly.swarm.config.naming.RemoteNamingService;
/**
 * The configuration of the naming subsystem.
 */
@ResourceType("subsystem")
@Implicit
public class Naming<T extends Naming> {

	private String key;
	private NamingResources subresources = new NamingResources();
	private RemoteNamingService remoteNamingService;

	public Naming() {
		this.key = "naming";
	}

	public String getKey() {
		return this.key;
	}

	public NamingResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.naming.Binding objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.naming.Binding objects.
	 */
	@SuppressWarnings("unchecked")
	public T bindings(List<org.wildfly.swarm.config.naming.Binding> value) {
		this.subresources.bindings.addAll(value);
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.naming.Binding object to the list of subresources
	 * @param value The org.wildfly.swarm.config.naming.Binding to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T binding(Binding value) {
		this.subresources.bindings.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Naming
	 */
	public class NamingResources {
		/**
		 * JNDI bindings for primitive types
		 */
		private List<org.wildfly.swarm.config.naming.Binding> bindings = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.naming.Binding resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Binding> bindings() {
			return this.bindings;
		}
	}

	/**
	 * The remote naming server
	 */
	@Subresource
	public RemoteNamingService remoteNamingService() {
		return this.remoteNamingService;
	}

	/**
	 * The remote naming server
	 */
	@SuppressWarnings("unchecked")
	public T remoteNamingService(RemoteNamingService value) {
		this.remoteNamingService = value;
		return (T) this;
	}
}