package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.SecurityDomain;
import org.wildfly.swarm.config.security.ClassicVault;
/**
 * The configuration of the security subsystem.
 */
@ResourceType("subsystem")
@Implicit
public class Security<T extends Security> {

	private String key;
	private Boolean deepCopySubjectMode;
	private SecurityResources subresources = new SecurityResources();
	private ClassicVault classicVault;

	public Security() {
		this.key = "security";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Sets the copy mode of subjects done by the security managers to be deep copies that makes copies of the subject principals and credentials if they are cloneable. It should be set to true if subject include mutable content that can be corrupted when multiple threads have the same identity and cache flushes/logout clearing the subject in one thread results in subject references affecting other threads.
	 */
	@ModelNodeBinding(detypedName = "deep-copy-subject-mode")
	public Boolean deepCopySubjectMode() {
		return this.deepCopySubjectMode;
	}

	/**
	 * Sets the copy mode of subjects done by the security managers to be deep copies that makes copies of the subject principals and credentials if they are cloneable. It should be set to true if subject include mutable content that can be corrupted when multiple threads have the same identity and cache flushes/logout clearing the subject in one thread results in subject references affecting other threads.
	 */
	@SuppressWarnings("unchecked")
	public T deepCopySubjectMode(Boolean value) {
		this.deepCopySubjectMode = value;
		return (T) this;
	}

	public SecurityResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.security.SecurityDomain objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.security.SecurityDomain objects.
	 */
	@SuppressWarnings("unchecked")
	public T securityDomains(
			List<org.wildfly.swarm.config.security.SecurityDomain> value) {
		this.subresources.securityDomains.addAll(value);
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.security.SecurityDomain object to the list of subresources
	 * @param value The org.wildfly.swarm.config.security.SecurityDomain to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T securityDomain(SecurityDomain value) {
		this.subresources.securityDomains.add(value);
		return (T) this;
	}

	/**
	 * Child mutators for Security
	 */
	public class SecurityResources {
		/**
		 * Configures a security domain. Authentication, authorization, ACL, mapping, auditing and identity trust are configured here.
		 */
		private List<org.wildfly.swarm.config.security.SecurityDomain> securityDomains = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.security.SecurityDomain resources
		 * @return the list of resources
		 */
		@Subresource
		public List<SecurityDomain> securityDomains() {
			return this.securityDomains;
		}
	}

	/**
	 * Security Vault for attributes.
	 */
	@Subresource
	public ClassicVault classicVault() {
		return this.classicVault;
	}

	/**
	 * Security Vault for attributes.
	 */
	@SuppressWarnings("unchecked")
	public T classicVault(ClassicVault value) {
		this.classicVault = value;
		return (T) this;
	}
}