package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A clustered passivation store
 */
@ResourceType("cluster-passivation-store")
public class ClusterPassivationStore {

	private String key;
	private String beanCache;
	private String cacheContainer;
	private Long idleTimeout;
	private Integer maxSize;

	public ClusterPassivationStore(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The name of the cache used to store bean instances.
	 */
	@ModelNodeBinding(detypedName = "bean-cache")
	public String beanCache() {
		return this.beanCache;
	}

	/**
	 * The name of the cache used to store bean instances.
	 */
	@SuppressWarnings("unchecked")
	public ClusterPassivationStore beanCache(String value) {
		this.beanCache = value;
		return (ClusterPassivationStore) this;
	}

	/**
	 * The name of the cache container used for the bean and client-mappings caches
	 */
	@ModelNodeBinding(detypedName = "cache-container")
	public String cacheContainer() {
		return this.cacheContainer;
	}

	/**
	 * The name of the cache container used for the bean and client-mappings caches
	 */
	@SuppressWarnings("unchecked")
	public ClusterPassivationStore cacheContainer(String value) {
		this.cacheContainer = value;
		return (ClusterPassivationStore) this;
	}

	/**
	 * The timeout in units specified by idle-timeout-unit, after which a bean will passivate
	 */
	@ModelNodeBinding(detypedName = "idle-timeout")
	public Long idleTimeout() {
		return this.idleTimeout;
	}

	/**
	 * The timeout in units specified by idle-timeout-unit, after which a bean will passivate
	 */
	@SuppressWarnings("unchecked")
	public ClusterPassivationStore idleTimeout(Long value) {
		this.idleTimeout = value;
		return (ClusterPassivationStore) this;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old beans to passivate
	 */
	@ModelNodeBinding(detypedName = "max-size")
	public Integer maxSize() {
		return this.maxSize;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old beans to passivate
	 */
	@SuppressWarnings("unchecked")
	public ClusterPassivationStore maxSize(Integer value) {
		this.maxSize = value;
		return (ClusterPassivationStore) this;
	}
}