package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The IIOP service
 */
@ResourceType("service")
@Implicit
public class IiopService {

	private String key;
	private Boolean enableByDefault;
	private Boolean useQualifiedName;

	public IiopService() {
		this.key = "iiop";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * If this is true EJB's will be exposed over IIOP by default, otherwise it needs to be explicitly enabled in the deployment descriptor
	 */
	@ModelNodeBinding(detypedName = "enable-by-default")
	public Boolean enableByDefault() {
		return this.enableByDefault;
	}

	/**
	 * If this is true EJB's will be exposed over IIOP by default, otherwise it needs to be explicitly enabled in the deployment descriptor
	 */
	@SuppressWarnings("unchecked")
	public IiopService enableByDefault(Boolean value) {
		this.enableByDefault = value;
		return (IiopService) this;
	}

	/**
	 * If true EJB names will be bound into the naming service with the application and module name prepended to the name (e.g. myapp/mymodule/MyEjb)
	 */
	@ModelNodeBinding(detypedName = "use-qualified-name")
	public Boolean useQualifiedName() {
		return this.useQualifiedName;
	}

	/**
	 * If true EJB names will be bound into the naming service with the application and module name prepended to the name (e.g. myapp/mymodule/MyEjb)
	 */
	@SuppressWarnings("unchecked")
	public IiopService useQualifiedName(Boolean value) {
		this.useQualifiedName = value;
		return (IiopService) this;
	}
}