package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A passivation store
 */
@ResourceType("passivation-store")
public class PassivationStore {

	private String key;
	private String beanCache;
	private String cacheContainer;
	private Integer maxSize;

	public PassivationStore(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The name of the cache used to store bean instances.
	 */
	@ModelNodeBinding(detypedName = "bean-cache")
	public String beanCache() {
		return this.beanCache;
	}

	/**
	 * The name of the cache used to store bean instances.
	 */
	@SuppressWarnings("unchecked")
	public PassivationStore beanCache(String value) {
		this.beanCache = value;
		return (PassivationStore) this;
	}

	/**
	 * The name of the cache container used for the bean and client-mappings caches
	 */
	@ModelNodeBinding(detypedName = "cache-container")
	public String cacheContainer() {
		return this.cacheContainer;
	}

	/**
	 * The name of the cache container used for the bean and client-mappings caches
	 */
	@SuppressWarnings("unchecked")
	public PassivationStore cacheContainer(String value) {
		this.cacheContainer = value;
		return (PassivationStore) this;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old beans to passivate
	 */
	@ModelNodeBinding(detypedName = "max-size")
	public Integer maxSize() {
		return this.maxSize;
	}

	/**
	 * The maximum number of beans this cache should store before forcing old beans to passivate
	 */
	@SuppressWarnings("unchecked")
	public PassivationStore maxSize(Integer value) {
		this.maxSize = value;
		return (PassivationStore) this;
	}
}