package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.ejb3.remoting_profile.RemotingEjbReceiver;
/**
 * A remoting profile
 */
@ResourceType("remoting-profile")
public class RemotingProfile {

	private String key;
	private Boolean excludeLocalReceiver;
	private Boolean localReceiverPassByValue;
	private RemotingProfileResources subresources = new RemotingProfileResources();

	public RemotingProfile(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * If set no local receiver is used in this profile
	 */
	@ModelNodeBinding(detypedName = "exclude-local-receiver")
	public Boolean excludeLocalReceiver() {
		return this.excludeLocalReceiver;
	}

	/**
	 * If set no local receiver is used in this profile
	 */
	@SuppressWarnings("unchecked")
	public RemotingProfile excludeLocalReceiver(Boolean value) {
		this.excludeLocalReceiver = value;
		return (RemotingProfile) this;
	}

	/**
	 * If set local receiver will pass ejb beans by value
	 */
	@ModelNodeBinding(detypedName = "local-receiver-pass-by-value")
	public Boolean localReceiverPassByValue() {
		return this.localReceiverPassByValue;
	}

	/**
	 * If set local receiver will pass ejb beans by value
	 */
	@SuppressWarnings("unchecked")
	public RemotingProfile localReceiverPassByValue(Boolean value) {
		this.localReceiverPassByValue = value;
		return (RemotingProfile) this;
	}

	public RemotingProfileResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.ejb3.remoting_profile.RemotingEjbReceiver objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.ejb3.remoting_profile.RemotingEjbReceiver objects.
	 */
	@SuppressWarnings("unchecked")
	public RemotingProfile remotingEjbReceivers(
			List<org.wildfly.swarm.config.ejb3.remoting_profile.RemotingEjbReceiver> value) {
		this.subresources.remotingEjbReceivers.addAll(value);
		return (RemotingProfile) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.ejb3.remoting_profile.RemotingEjbReceiver object to the list of subresources
	 * @param value The org.wildfly.swarm.config.ejb3.remoting_profile.RemotingEjbReceiver to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public RemotingProfile remotingEjbReceiver(RemotingEjbReceiver value) {
		this.subresources.remotingEjbReceivers.add(value);
		return (RemotingProfile) this;
	}

	/**
	 * Child mutators for RemotingProfile
	 */
	public class RemotingProfileResources {
		/**
		 * A remoting ejb receiver reference included in the profile
		 */
		private List<org.wildfly.swarm.config.ejb3.remoting_profile.RemotingEjbReceiver> remotingEjbReceivers = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.ejb3.remoting_profile.RemotingEjbReceiver resources
		 * @return the list of resources
		 */
		@Subresource
		public List<RemotingEjbReceiver> remotingEjbReceivers() {
			return this.remotingEjbReceivers;
		}
	}
}