package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A backup site to which to replicate this cache.
 */
@ResourceType("backup")
public class Backup {

	private String key;
	private Integer afterFailures;
	private Boolean enabled;
	private String failurePolicy;
	private Long minWait;
	private String strategy;
	private Long timeout;

	public Backup(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Indicates the number of failures after which this backup site should go offline.
	 */
	@ModelNodeBinding(detypedName = "after-failures")
	public Integer afterFailures() {
		return this.afterFailures;
	}

	/**
	 * Indicates the number of failures after which this backup site should go offline.
	 */
	@SuppressWarnings("unchecked")
	public Backup afterFailures(Integer value) {
		this.afterFailures = value;
		return (Backup) this;
	}

	/**
	 * Indicates whether or not this backup site is enabled.
	 */
	@ModelNodeBinding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * Indicates whether or not this backup site is enabled.
	 */
	@SuppressWarnings("unchecked")
	public Backup enabled(Boolean value) {
		this.enabled = value;
		return (Backup) this;
	}

	/**
	 * The policy to follow when connectivity to the backup site fails.
	 */
	@ModelNodeBinding(detypedName = "failure-policy")
	public String failurePolicy() {
		return this.failurePolicy;
	}

	/**
	 * The policy to follow when connectivity to the backup site fails.
	 */
	@SuppressWarnings("unchecked")
	public Backup failurePolicy(String value) {
		this.failurePolicy = value;
		return (Backup) this;
	}

	/**
	 * Indicates the minimum time (in milliseconds) to wait after the max number of failures is reached, after which this backup site should go offline.
	 */
	@ModelNodeBinding(detypedName = "min-wait")
	public Long minWait() {
		return this.minWait;
	}

	/**
	 * Indicates the minimum time (in milliseconds) to wait after the max number of failures is reached, after which this backup site should go offline.
	 */
	@SuppressWarnings("unchecked")
	public Backup minWait(Long value) {
		this.minWait = value;
		return (Backup) this;
	}

	/**
	 * The backup strategy for this cache
	 */
	@ModelNodeBinding(detypedName = "strategy")
	public String strategy() {
		return this.strategy;
	}

	/**
	 * The backup strategy for this cache
	 */
	@SuppressWarnings("unchecked")
	public Backup strategy(String value) {
		this.strategy = value;
		return (Backup) this;
	}

	/**
	 * The timeout for replicating to the backup site.
	 */
	@ModelNodeBinding(detypedName = "timeout")
	public Long timeout() {
		return this.timeout;
	}

	/**
	 * The timeout for replicating to the backup site.
	 */
	@SuppressWarnings("unchecked")
	public Backup timeout(Long value) {
		this.timeout = value;
		return (Backup) this;
	}
}