package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A cache for which this cache acts as a backup (for use with cross site replication).
 */
@ResourceType("component")
@Implicit
public class BackupForComponent {

	private String key;
	private String remoteCache;
	private String remoteSite;

	public BackupForComponent() {
		this.key = "backup-for";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The name of the remote cache for which this cache acts as a backup.
	 */
	@ModelNodeBinding(detypedName = "remote-cache")
	public String remoteCache() {
		return this.remoteCache;
	}

	/**
	 * The name of the remote cache for which this cache acts as a backup.
	 */
	@SuppressWarnings("unchecked")
	public BackupForComponent remoteCache(String value) {
		this.remoteCache = value;
		return (BackupForComponent) this;
	}

	/**
	 * The site of the remote cache for which this cache acts as a backup.
	 */
	@ModelNodeBinding(detypedName = "remote-site")
	public String remoteSite() {
		return this.remoteSite;
	}

	/**
	 * The site of the remote cache for which this cache acts as a backup.
	 */
	@SuppressWarnings("unchecked")
	public BackupForComponent remoteSite(String value) {
		this.remoteSite = value;
		return (BackupForComponent) this;
	}
}