package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The partition handling configuration for distributed and replicated caches.
 */
@ResourceType("component")
@Implicit
public class PartitionHandlingComponent {

	private String key;
	private String availability;
	private Boolean enabled;

	public PartitionHandlingComponent() {
		this.key = "partition-handling";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Indicates the current availability of the cache.
	 */
	@ModelNodeBinding(detypedName = "availability")
	public String availability() {
		return this.availability;
	}

	/**
	 * Indicates the current availability of the cache.
	 */
	@SuppressWarnings("unchecked")
	public PartitionHandlingComponent availability(String value) {
		this.availability = value;
		return (PartitionHandlingComponent) this;
	}

	/**
	 * If enabled, the cache will enter degraded mode upon detecting a network partition that threatens the integrity of the cache.
	 */
	@ModelNodeBinding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * If enabled, the cache will enter degraded mode upon detecting a network partition that threatens the integrity of the cache.
	 */
	@SuppressWarnings("unchecked")
	public PartitionHandlingComponent enabled(Boolean value) {
		this.enabled = value;
		return (PartitionHandlingComponent) this;
	}
}