package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Defines a thread pool used for interacting with the persistent store.
 */
@ResourceType("thread-pool")
@Implicit
public class PersistenceThreadPool {

	private String key;
	private Long keepaliveTime;
	private Integer maxThreads;
	private Integer minThreads;
	private Integer queueLength;

	public PersistenceThreadPool() {
		this.key = "persistence";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Used to specify the amount of milliseconds that pool threads should be kept running when idle; if not specified, threads will run until the executor is shut down.
	 */
	@ModelNodeBinding(detypedName = "keepalive-time")
	public Long keepaliveTime() {
		return this.keepaliveTime;
	}

	/**
	 * Used to specify the amount of milliseconds that pool threads should be kept running when idle; if not specified, threads will run until the executor is shut down.
	 */
	@SuppressWarnings("unchecked")
	public PersistenceThreadPool keepaliveTime(Long value) {
		this.keepaliveTime = value;
		return (PersistenceThreadPool) this;
	}

	/**
	 * The maximum thread pool size.
	 */
	@ModelNodeBinding(detypedName = "max-threads")
	public Integer maxThreads() {
		return this.maxThreads;
	}

	/**
	 * The maximum thread pool size.
	 */
	@SuppressWarnings("unchecked")
	public PersistenceThreadPool maxThreads(Integer value) {
		this.maxThreads = value;
		return (PersistenceThreadPool) this;
	}

	/**
	 * The core thread pool size which is smaller than the maximum pool size. If undefined, the core thread pool size is the same as the maximum thread pool size.
	 */
	@ModelNodeBinding(detypedName = "min-threads")
	public Integer minThreads() {
		return this.minThreads;
	}

	/**
	 * The core thread pool size which is smaller than the maximum pool size. If undefined, the core thread pool size is the same as the maximum thread pool size.
	 */
	@SuppressWarnings("unchecked")
	public PersistenceThreadPool minThreads(Integer value) {
		this.minThreads = value;
		return (PersistenceThreadPool) this;
	}

	/**
	 * The queue length.
	 */
	@ModelNodeBinding(detypedName = "queue-length")
	public Integer queueLength() {
		return this.queueLength;
	}

	/**
	 * The queue length.
	 */
	@SuppressWarnings("unchecked")
	public PersistenceThreadPool queueLength(Integer value) {
		this.queueLength = value;
		return (PersistenceThreadPool) this;
	}
}