package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.Subresource;
/**
 * A replicated cache configuration
 */
@ResourceType("replicated-cache")
public class ReplicatedCache {

	private String key;
	private Long activations;
	private Long averageReadTime;
	private Long averageReplicationTime;
	private Long averageWriteTime;
	private String cacheStatus;
	private Long elapsedTime;
	private Double hitRatio;
	private Long hits;
	private Long invalidations;
	private String jndiName;
	private Long misses;
	private String mode;
	private String module;
	private Integer numberOfEntries;
	private Long passivations;
	private Long queueFlushInterval;
	private Integer queueSize;
	private Double readWriteRatio;
	private Long remoteTimeout;
	private Long removeHits;
	private Long removeMisses;
	private Long replicationCount;
	private Long replicationFailures;
	private Boolean statisticsEnabled;
	private Long stores;
	private Double successRatio;
	private Long timeSinceReset;
	private EvictionComponent evictionComponent;
	private ExpirationComponent expirationComponent;
	private CustomStore customStore;
	private NoneStore noneStore;
	private BackupForComponent backupForComponent;
	private TransactionComponent transactionComponent;
	private BinaryJdbcStore binaryJdbcStore;
	private StringJdbcStore stringJdbcStore;
	private FileStore fileStore;
	private StateTransferComponent stateTransferComponent;
	private PartitionHandlingComponent partitionHandlingComponent;
	private LockingComponent lockingComponent;
	private BackupsComponent backupsComponent;
	private MixedJdbcStore mixedJdbcStore;
	private RemoteStore remoteStore;

	public ReplicatedCache(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The number of cache node activations (bringing a node into memory from a cache store) . May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "activations")
	public Long activations() {
		return this.activations;
	}

	/**
	 * The number of cache node activations (bringing a node into memory from a cache store) . May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache activations(Long value) {
		this.activations = value;
		return (ReplicatedCache) this;
	}

	/**
	 * Average time (in ms) for cache reads. Includes hits and misses. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "average-read-time")
	public Long averageReadTime() {
		return this.averageReadTime;
	}

	/**
	 * Average time (in ms) for cache reads. Includes hits and misses. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache averageReadTime(Long value) {
		this.averageReadTime = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The average time taken to replicate data around the cluster. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "average-replication-time")
	public Long averageReplicationTime() {
		return this.averageReplicationTime;
	}

	/**
	 * The average time taken to replicate data around the cluster. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache averageReplicationTime(Long value) {
		this.averageReplicationTime = value;
		return (ReplicatedCache) this;
	}

	/**
	 * Average time (in ms) for cache writes. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "average-write-time")
	public Long averageWriteTime() {
		return this.averageWriteTime;
	}

	/**
	 * Average time (in ms) for cache writes. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache averageWriteTime(Long value) {
		this.averageWriteTime = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The status of the cache component. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "cache-status")
	public String cacheStatus() {
		return this.cacheStatus;
	}

	/**
	 * The status of the cache component. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache cacheStatus(String value) {
		this.cacheStatus = value;
		return (ReplicatedCache) this;
	}

	/**
	 * Time (in secs) since cache started. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "elapsed-time")
	public Long elapsedTime() {
		return this.elapsedTime;
	}

	/**
	 * Time (in secs) since cache started. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache elapsedTime(Long value) {
		this.elapsedTime = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The hit/miss ratio for the cache (hits/hits+misses). May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "hit-ratio")
	public Double hitRatio() {
		return this.hitRatio;
	}

	/**
	 * The hit/miss ratio for the cache (hits/hits+misses). May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache hitRatio(Double value) {
		this.hitRatio = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The number of cache attribute hits. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "hits")
	public Long hits() {
		return this.hits;
	}

	/**
	 * The number of cache attribute hits. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache hits(Long value) {
		this.hits = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The number of cache invalidations. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "invalidations")
	public Long invalidations() {
		return this.invalidations;
	}

	/**
	 * The number of cache invalidations. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache invalidations(Long value) {
		this.invalidations = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The jndi-name to which to bind this cache instance.
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * The jndi-name to which to bind this cache instance.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache jndiName(String value) {
		this.jndiName = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The number of cache attribute misses. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "misses")
	public Long misses() {
		return this.misses;
	}

	/**
	 * The number of cache attribute misses. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache misses(Long value) {
		this.misses = value;
		return (ReplicatedCache) this;
	}

	/**
	 * Sets the clustered cache mode, ASYNC for asynchronous operation, or SYNC for synchronous operation.
	 */
	@ModelNodeBinding(detypedName = "mode")
	public String mode() {
		return this.mode;
	}

	/**
	 * Sets the clustered cache mode, ASYNC for asynchronous operation, or SYNC for synchronous operation.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache mode(String value) {
		this.mode = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The module whose class loader should be used when building this cache's configuration.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * The module whose class loader should be used when building this cache's configuration.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache module(String value) {
		this.module = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The current number of entries in the cache. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "number-of-entries")
	public Integer numberOfEntries() {
		return this.numberOfEntries;
	}

	/**
	 * The current number of entries in the cache. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache numberOfEntries(Integer value) {
		this.numberOfEntries = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The number of cache node passivations (passivating a node from memory to a cache store). May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "passivations")
	public Long passivations() {
		return this.passivations;
	}

	/**
	 * The number of cache node passivations (passivating a node from memory to a cache store). May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache passivations(Long value) {
		this.passivations = value;
		return (ReplicatedCache) this;
	}

	/**
	 * In ASYNC mode, this attribute controls how often the asynchronous thread used to flush the replication queue runs. This should be a positive integer which represents thread wakeup time in milliseconds.
	 */
	@ModelNodeBinding(detypedName = "queue-flush-interval")
	public Long queueFlushInterval() {
		return this.queueFlushInterval;
	}

	/**
	 * In ASYNC mode, this attribute controls how often the asynchronous thread used to flush the replication queue runs. This should be a positive integer which represents thread wakeup time in milliseconds.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache queueFlushInterval(Long value) {
		this.queueFlushInterval = value;
		return (ReplicatedCache) this;
	}

	/**
	 * In ASYNC mode, this attribute can be used to trigger flushing of the queue when it reaches a specific threshold.
	 */
	@ModelNodeBinding(detypedName = "queue-size")
	public Integer queueSize() {
		return this.queueSize;
	}

	/**
	 * In ASYNC mode, this attribute can be used to trigger flushing of the queue when it reaches a specific threshold.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache queueSize(Integer value) {
		this.queueSize = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The read/write ratio of the cache ((hits+misses)/stores). May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "read-write-ratio")
	public Double readWriteRatio() {
		return this.readWriteRatio;
	}

	/**
	 * The read/write ratio of the cache ((hits+misses)/stores). May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache readWriteRatio(Double value) {
		this.readWriteRatio = value;
		return (ReplicatedCache) this;
	}

	/**
	 * In SYNC mode, the timeout (in ms) used to wait for an acknowledgment when making a remote call, after which the call is aborted and an exception is thrown.
	 */
	@ModelNodeBinding(detypedName = "remote-timeout")
	public Long remoteTimeout() {
		return this.remoteTimeout;
	}

	/**
	 * In SYNC mode, the timeout (in ms) used to wait for an acknowledgment when making a remote call, after which the call is aborted and an exception is thrown.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache remoteTimeout(Long value) {
		this.remoteTimeout = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The number of cache attribute remove hits. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "remove-hits")
	public Long removeHits() {
		return this.removeHits;
	}

	/**
	 * The number of cache attribute remove hits. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache removeHits(Long value) {
		this.removeHits = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The number of cache attribute remove misses. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "remove-misses")
	public Long removeMisses() {
		return this.removeMisses;
	}

	/**
	 * The number of cache attribute remove misses. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache removeMisses(Long value) {
		this.removeMisses = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The number of times data was replicated around the cluster. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "replication-count")
	public Long replicationCount() {
		return this.replicationCount;
	}

	/**
	 * The number of times data was replicated around the cluster. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache replicationCount(Long value) {
		this.replicationCount = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The number of data replication failures. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "replication-failures")
	public Long replicationFailures() {
		return this.replicationFailures;
	}

	/**
	 * The number of data replication failures. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache replicationFailures(Long value) {
		this.replicationFailures = value;
		return (ReplicatedCache) this;
	}

	/**
	 * If enabled, statistics will be collected for this cache
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * If enabled, statistics will be collected for this cache
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache statisticsEnabled(Boolean value) {
		this.statisticsEnabled = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The number of cache attribute put operations. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "stores")
	public Long stores() {
		return this.stores;
	}

	/**
	 * The number of cache attribute put operations. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache stores(Long value) {
		this.stores = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The data replication success ratio (successes/successes+failures). May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "success-ratio")
	public Double successRatio() {
		return this.successRatio;
	}

	/**
	 * The data replication success ratio (successes/successes+failures). May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache successRatio(Double value) {
		this.successRatio = value;
		return (ReplicatedCache) this;
	}

	/**
	 * Time (in secs) since cache statistics were reset. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "time-since-reset")
	public Long timeSinceReset() {
		return this.timeSinceReset;
	}

	/**
	 * Time (in secs) since cache statistics were reset. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache timeSinceReset(Long value) {
		this.timeSinceReset = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The cache eviction configuration.
	 */
	@Subresource
	public EvictionComponent evictionComponent() {
		return this.evictionComponent;
	}

	/**
	 * The cache eviction configuration.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache evictionComponent(EvictionComponent value) {
		this.evictionComponent = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The cache expiration configuration.
	 */
	@Subresource
	public ExpirationComponent expirationComponent() {
		return this.expirationComponent;
	}

	/**
	 * The cache expiration configuration.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache expirationComponent(ExpirationComponent value) {
		this.expirationComponent = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The cache store configuration.
	 */
	@Subresource
	public CustomStore customStore() {
		return this.customStore;
	}

	/**
	 * The cache store configuration.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache customStore(CustomStore value) {
		this.customStore = value;
		return (ReplicatedCache) this;
	}

	/**
	 * A store-less configuration.
	 */
	@Subresource
	public NoneStore noneStore() {
		return this.noneStore;
	}

	/**
	 * A store-less configuration.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache noneStore(NoneStore value) {
		this.noneStore = value;
		return (ReplicatedCache) this;
	}

	/**
	 * A cache for which this cache acts as a backup (for use with cross site replication).
	 */
	@Subresource
	public BackupForComponent backupForComponent() {
		return this.backupForComponent;
	}

	/**
	 * A cache for which this cache acts as a backup (for use with cross site replication).
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache backupForComponent(BackupForComponent value) {
		this.backupForComponent = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@Subresource
	public TransactionComponent transactionComponent() {
		return this.transactionComponent;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache transactionComponent(TransactionComponent value) {
		this.transactionComponent = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@Subresource
	public BinaryJdbcStore binaryJdbcStore() {
		return this.binaryJdbcStore;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache binaryJdbcStore(BinaryJdbcStore value) {
		this.binaryJdbcStore = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@Subresource
	public StringJdbcStore stringJdbcStore() {
		return this.stringJdbcStore;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache stringJdbcStore(StringJdbcStore value) {
		this.stringJdbcStore = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The cache file store configuration.
	 */
	@Subresource
	public FileStore fileStore() {
		return this.fileStore;
	}

	/**
	 * The cache file store configuration.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache fileStore(FileStore value) {
		this.fileStore = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The state transfer configuration for distributed and replicated caches.
	 */
	@Subresource
	public StateTransferComponent stateTransferComponent() {
		return this.stateTransferComponent;
	}

	/**
	 * The state transfer configuration for distributed and replicated caches.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache stateTransferComponent(StateTransferComponent value) {
		this.stateTransferComponent = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The partition handling configuration for distributed and replicated caches.
	 */
	@Subresource
	public PartitionHandlingComponent partitionHandlingComponent() {
		return this.partitionHandlingComponent;
	}

	/**
	 * The partition handling configuration for distributed and replicated caches.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache partitionHandlingComponent(
			PartitionHandlingComponent value) {
		this.partitionHandlingComponent = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@Subresource
	public LockingComponent lockingComponent() {
		return this.lockingComponent;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache lockingComponent(LockingComponent value) {
		this.lockingComponent = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The remote backups for this cache.
	 */
	@Subresource
	public BackupsComponent backupsComponent() {
		return this.backupsComponent;
	}

	/**
	 * The remote backups for this cache.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache backupsComponent(BackupsComponent value) {
		this.backupsComponent = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@Subresource
	public MixedJdbcStore mixedJdbcStore() {
		return this.mixedJdbcStore;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache mixedJdbcStore(MixedJdbcStore value) {
		this.mixedJdbcStore = value;
		return (ReplicatedCache) this;
	}

	/**
	 * The cache remote store configuration.
	 */
	@Subresource
	public RemoteStore remoteStore() {
		return this.remoteStore;
	}

	/**
	 * The cache remote store configuration.
	 */
	@SuppressWarnings("unchecked")
	public ReplicatedCache remoteStore(RemoteStore value) {
		this.remoteStore = value;
		return (ReplicatedCache) this;
	}
}