package org.wildfly.swarm.config.io;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Defines buffer pool
 */
@ResourceType("buffer-pool")
public class BufferPool {

	private String key;
	private Integer bufferSize;
	private Integer buffersPerSlice;
	private Boolean directBuffers;

	public BufferPool(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * How big is the buffer
	 */
	@ModelNodeBinding(detypedName = "buffer-size")
	public Integer bufferSize() {
		return this.bufferSize;
	}

	/**
	 * How big is the buffer
	 */
	@SuppressWarnings("unchecked")
	public BufferPool bufferSize(Integer value) {
		this.bufferSize = value;
		return (BufferPool) this;
	}

	/**
	 * How many buffers per slice
	 */
	@ModelNodeBinding(detypedName = "buffers-per-slice")
	public Integer buffersPerSlice() {
		return this.buffersPerSlice;
	}

	/**
	 * How many buffers per slice
	 */
	@SuppressWarnings("unchecked")
	public BufferPool buffersPerSlice(Integer value) {
		this.buffersPerSlice = value;
		return (BufferPool) this;
	}

	/**
	 * Does the buffer pool use direct buffers
	 */
	@ModelNodeBinding(detypedName = "direct-buffers")
	public Boolean directBuffers() {
		return this.directBuffers;
	}

	/**
	 * Does the buffer pool use direct buffers
	 */
	@SuppressWarnings("unchecked")
	public BufferPool directBuffers(Boolean value) {
		this.directBuffers = value;
		return (BufferPool) this;
	}
}