package org.wildfly.swarm.config.io;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Defines workers
 */
@ResourceType("worker")
public class Worker {

	private String key;
	private Integer ioThreads;
	private Long stackSize;
	private Integer taskKeepalive;
	private Integer taskMaxThreads;

	public Worker(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Number of IO threads to use
	 */
	@ModelNodeBinding(detypedName = "io-threads")
	public Integer ioThreads() {
		return this.ioThreads;
	}

	/**
	 * Number of IO threads to use
	 */
	@SuppressWarnings("unchecked")
	public Worker ioThreads(Integer value) {
		this.ioThreads = value;
		return (Worker) this;
	}

	/**
	 * stack-size
	 */
	@ModelNodeBinding(detypedName = "stack-size")
	public Long stackSize() {
		return this.stackSize;
	}

	/**
	 * stack-size
	 */
	@SuppressWarnings("unchecked")
	public Worker stackSize(Long value) {
		this.stackSize = value;
		return (Worker) this;
	}

	/**
	 * task-keepalive
	 */
	@ModelNodeBinding(detypedName = "task-keepalive")
	public Integer taskKeepalive() {
		return this.taskKeepalive;
	}

	/**
	 * task-keepalive
	 */
	@SuppressWarnings("unchecked")
	public Worker taskKeepalive(Integer value) {
		this.taskKeepalive = value;
		return (Worker) this;
	}

	/**
	 * task-max-threads
	 */
	@ModelNodeBinding(detypedName = "task-max-threads")
	public Integer taskMaxThreads() {
		return this.taskMaxThreads;
	}

	/**
	 * task-max-threads
	 */
	@SuppressWarnings("unchecked")
	public Worker taskMaxThreads(Integer value) {
		this.taskMaxThreads = value;
		return (Worker) this;
	}
}