package org.wildfly.swarm.config.jca;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Bean validation (JSR-303) for resource adapters
 */
@ResourceType("bean-validation")
@Implicit
public class BeanValidation {

	private String key;
	private Boolean enabled;

	public BeanValidation() {
		this.key = "bean-validation";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Specify whether bean validation is enabled
	 */
	@ModelNodeBinding(detypedName = "enabled")
	public Boolean enabled() {
		return this.enabled;
	}

	/**
	 * Specify whether bean validation is enabled
	 */
	@SuppressWarnings("unchecked")
	public BeanValidation enabled(Boolean value) {
		this.enabled = value;
		return (BeanValidation) this;
	}
}