package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * An acceptor defines a way in which connections can be made to the ActiveMQ server.
 */
@ResourceType("acceptor")
public class Acceptor {

	private String key;
	private String factoryClass;
	private Map params;
	private String socketBinding;
	private Boolean started;

	public Acceptor(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Class name of the factory class that can instantiate the acceptor.
	 */
	@ModelNodeBinding(detypedName = "factory-class")
	public String factoryClass() {
		return this.factoryClass;
	}

	/**
	 * Class name of the factory class that can instantiate the acceptor.
	 */
	@SuppressWarnings("unchecked")
	public Acceptor factoryClass(String value) {
		this.factoryClass = value;
		return (Acceptor) this;
	}

	/**
	 * A key-value pair understood by the acceptor factory-class and used to configure it.
	 */
	@ModelNodeBinding(detypedName = "params")
	public Map params() {
		return this.params;
	}

	/**
	 * A key-value pair understood by the acceptor factory-class and used to configure it.
	 */
	@SuppressWarnings("unchecked")
	public Acceptor params(Map value) {
		this.params = value;
		return (Acceptor) this;
	}

	/**
	 * The socket binding that the acceptor will use to accept connections.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The socket binding that the acceptor will use to accept connections.
	 */
	@SuppressWarnings("unchecked")
	public Acceptor socketBinding(String value) {
		this.socketBinding = value;
		return (Acceptor) this;
	}

	/**
	 * Whether this acceptor is started.
	 */
	@ModelNodeBinding(detypedName = "started")
	public Boolean started() {
		return this.started;
	}

	/**
	 * Whether this acceptor is started.
	 */
	@SuppressWarnings("unchecked")
	public Acceptor started(Boolean value) {
		this.started = value;
		return (Acceptor) this;
	}
}