package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.math.BigDecimal;
import java.util.List;
/**
 * The function of a bridge is to consume messages from a source queue, and forward them to a target address, typically on a different ActiveMQ server.
 */
@ResourceType("bridge")
public class Bridge {

	private String key;
	private Long checkPeriod;
	private Integer confirmationWindowSize;
	private Long connectionTtl;
	private String discoveryGroup;
	private String filter;
	private String forwardingAddress;
	private Boolean ha;
	private Integer initialConnectAttempts;
	private Long maxRetryInterval;
	private Integer minLargeMessageSize;
	private String password;
	private String queueName;
	private Integer reconnectAttempts;
	private Integer reconnectAttemptsOnSameNode;
	private Long retryInterval;
	private BigDecimal retryIntervalMultiplier;
	private Boolean started;
	private List<String> staticConnectors;
	private String transformerClassName;
	private Boolean useDuplicateDetection;
	private String user;

	public Bridge(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The period (in milliseconds) between client failure check.
	 */
	@ModelNodeBinding(detypedName = "check-period")
	public Long checkPeriod() {
		return this.checkPeriod;
	}

	/**
	 * The period (in milliseconds) between client failure check.
	 */
	@SuppressWarnings("unchecked")
	public Bridge checkPeriod(Long value) {
		this.checkPeriod = value;
		return (Bridge) this;
	}

	/**
	 * The confirmation-window-size to use for the connection used to forward messages to the target node.
	 */
	@ModelNodeBinding(detypedName = "confirmation-window-size")
	public Integer confirmationWindowSize() {
		return this.confirmationWindowSize;
	}

	/**
	 * The confirmation-window-size to use for the connection used to forward messages to the target node.
	 */
	@SuppressWarnings("unchecked")
	public Bridge confirmationWindowSize(Integer value) {
		this.confirmationWindowSize = value;
		return (Bridge) this;
	}

	/**
	 * The maximum time (in milliseconds) for which the connections used by the bridges are considered alive (in the absence of heartbeat).
	 */
	@ModelNodeBinding(detypedName = "connection-ttl")
	public Long connectionTtl() {
		return this.connectionTtl;
	}

	/**
	 * The maximum time (in milliseconds) for which the connections used by the bridges are considered alive (in the absence of heartbeat).
	 */
	@SuppressWarnings("unchecked")
	public Bridge connectionTtl(Long value) {
		this.connectionTtl = value;
		return (Bridge) this;
	}

	/**
	 * The name of the discovery group used by this bridge. Must be undefined (null) if 'static-connectors' is defined.
	 */
	@ModelNodeBinding(detypedName = "discovery-group")
	public String discoveryGroup() {
		return this.discoveryGroup;
	}

	/**
	 * The name of the discovery group used by this bridge. Must be undefined (null) if 'static-connectors' is defined.
	 */
	@SuppressWarnings("unchecked")
	public Bridge discoveryGroup(String value) {
		this.discoveryGroup = value;
		return (Bridge) this;
	}

	/**
	 * An optional filter string. If specified then only messages which match the filter expression specified will be forwarded. The filter string follows the ActiveMQ filter expression syntax described in the ActiveMQ documentation.
	 */
	@ModelNodeBinding(detypedName = "filter")
	public String filter() {
		return this.filter;
	}

	/**
	 * An optional filter string. If specified then only messages which match the filter expression specified will be forwarded. The filter string follows the ActiveMQ filter expression syntax described in the ActiveMQ documentation.
	 */
	@SuppressWarnings("unchecked")
	public Bridge filter(String value) {
		this.filter = value;
		return (Bridge) this;
	}

	/**
	 * The address on the target server that the message will be forwarded to. If a forwarding address is not specified then the original destination of the message will be retained.
	 */
	@ModelNodeBinding(detypedName = "forwarding-address")
	public String forwardingAddress() {
		return this.forwardingAddress;
	}

	/**
	 * The address on the target server that the message will be forwarded to. If a forwarding address is not specified then the original destination of the message will be retained.
	 */
	@SuppressWarnings("unchecked")
	public Bridge forwardingAddress(String value) {
		this.forwardingAddress = value;
		return (Bridge) this;
	}

	/**
	 * Whether or not this bridge should support high availability. True means it will connect to any available server in a cluster and support failover.
	 */
	@ModelNodeBinding(detypedName = "ha")
	public Boolean ha() {
		return this.ha;
	}

	/**
	 * Whether or not this bridge should support high availability. True means it will connect to any available server in a cluster and support failover.
	 */
	@SuppressWarnings("unchecked")
	public Bridge ha(Boolean value) {
		this.ha = value;
		return (Bridge) this;
	}

	/**
	 * The number of attempts to connect initially with this bridge.
	 */
	@ModelNodeBinding(detypedName = "initial-connect-attempts")
	public Integer initialConnectAttempts() {
		return this.initialConnectAttempts;
	}

	/**
	 * The number of attempts to connect initially with this bridge.
	 */
	@SuppressWarnings("unchecked")
	public Bridge initialConnectAttempts(Integer value) {
		this.initialConnectAttempts = value;
		return (Bridge) this;
	}

	/**
	 * The maximum interval of time used to retry connections
	 */
	@ModelNodeBinding(detypedName = "max-retry-interval")
	public Long maxRetryInterval() {
		return this.maxRetryInterval;
	}

	/**
	 * The maximum interval of time used to retry connections
	 */
	@SuppressWarnings("unchecked")
	public Bridge maxRetryInterval(Long value) {
		this.maxRetryInterval = value;
		return (Bridge) this;
	}

	/**
	 * The minimum size (in bytes) for a message before it is considered as a large message.
	 */
	@ModelNodeBinding(detypedName = "min-large-message-size")
	public Integer minLargeMessageSize() {
		return this.minLargeMessageSize;
	}

	/**
	 * The minimum size (in bytes) for a message before it is considered as a large message.
	 */
	@SuppressWarnings("unchecked")
	public Bridge minLargeMessageSize(Integer value) {
		this.minLargeMessageSize = value;
		return (Bridge) this;
	}

	/**
	 * The password to use when creating the bridge connection to the remote server. If it is not specified the default cluster password specified by the cluster-password attribute in the root messaging subsystem resource will be used.
	 */
	@ModelNodeBinding(detypedName = "password")
	public String password() {
		return this.password;
	}

	/**
	 * The password to use when creating the bridge connection to the remote server. If it is not specified the default cluster password specified by the cluster-password attribute in the root messaging subsystem resource will be used.
	 */
	@SuppressWarnings("unchecked")
	public Bridge password(String value) {
		this.password = value;
		return (Bridge) this;
	}

	/**
	 * The unique name of the local queue that the bridge consumes from.
	 */
	@ModelNodeBinding(detypedName = "queue-name")
	public String queueName() {
		return this.queueName;
	}

	/**
	 * The unique name of the local queue that the bridge consumes from.
	 */
	@SuppressWarnings("unchecked")
	public Bridge queueName(String value) {
		this.queueName = value;
		return (Bridge) this;
	}

	/**
	 * The total number of reconnect attempts the bridge will make before giving up and shutting down. A value of -1 signifies an unlimited number of attempts.
	 */
	@ModelNodeBinding(detypedName = "reconnect-attempts")
	public Integer reconnectAttempts() {
		return this.reconnectAttempts;
	}

	/**
	 * The total number of reconnect attempts the bridge will make before giving up and shutting down. A value of -1 signifies an unlimited number of attempts.
	 */
	@SuppressWarnings("unchecked")
	public Bridge reconnectAttempts(Integer value) {
		this.reconnectAttempts = value;
		return (Bridge) this;
	}

	/**
	 * The total number of reconnect attempts on the same node the bridge will make before giving up and shutting down. A value of -1 signifies an unlimited number of attempts.
	 */
	@ModelNodeBinding(detypedName = "reconnect-attempts-on-same-node")
	public Integer reconnectAttemptsOnSameNode() {
		return this.reconnectAttemptsOnSameNode;
	}

	/**
	 * The total number of reconnect attempts on the same node the bridge will make before giving up and shutting down. A value of -1 signifies an unlimited number of attempts.
	 */
	@SuppressWarnings("unchecked")
	public Bridge reconnectAttemptsOnSameNode(Integer value) {
		this.reconnectAttemptsOnSameNode = value;
		return (Bridge) this;
	}

	/**
	 * The period in milliseconds between subsequent reconnection attempts, if the connection to the target server has failed.
	 */
	@ModelNodeBinding(detypedName = "retry-interval")
	public Long retryInterval() {
		return this.retryInterval;
	}

	/**
	 * The period in milliseconds between subsequent reconnection attempts, if the connection to the target server has failed.
	 */
	@SuppressWarnings("unchecked")
	public Bridge retryInterval(Long value) {
		this.retryInterval = value;
		return (Bridge) this;
	}

	/**
	 * A multiplier to apply to the time since the last retry to compute the time to the next retry. This allows you to implement an exponential backoff between retry attempts.
	 */
	@ModelNodeBinding(detypedName = "retry-interval-multiplier")
	public BigDecimal retryIntervalMultiplier() {
		return this.retryIntervalMultiplier;
	}

	/**
	 * A multiplier to apply to the time since the last retry to compute the time to the next retry. This allows you to implement an exponential backoff between retry attempts.
	 */
	@SuppressWarnings("unchecked")
	public Bridge retryIntervalMultiplier(BigDecimal value) {
		this.retryIntervalMultiplier = value;
		return (Bridge) this;
	}

	/**
	 * Whether the bridge is started.
	 */
	@ModelNodeBinding(detypedName = "started")
	public Boolean started() {
		return this.started;
	}

	/**
	 * Whether the bridge is started.
	 */
	@SuppressWarnings("unchecked")
	public Bridge started(Boolean value) {
		this.started = value;
		return (Bridge) this;
	}

	/**
	 * A list of names of statically defined connectors used by this bridge. Must be undefined (null) if 'discovery-group-name' is defined.
	 */
	@ModelNodeBinding(detypedName = "static-connectors")
	public List<String> staticConnectors() {
		return this.staticConnectors;
	}

	/**
	 * A list of names of statically defined connectors used by this bridge. Must be undefined (null) if 'discovery-group-name' is defined.
	 */
	@SuppressWarnings("unchecked")
	public Bridge staticConnectors(List<String> value) {
		this.staticConnectors = value;
		return (Bridge) this;
	}

	/**
	 * The name of a user-defined class which implements the org.apache.activemq.artemis.core.server.cluster.Transformer interface.
	 */
	@ModelNodeBinding(detypedName = "transformer-class-name")
	public String transformerClassName() {
		return this.transformerClassName;
	}

	/**
	 * The name of a user-defined class which implements the org.apache.activemq.artemis.core.server.cluster.Transformer interface.
	 */
	@SuppressWarnings("unchecked")
	public Bridge transformerClassName(String value) {
		this.transformerClassName = value;
		return (Bridge) this;
	}

	/**
	 * Whether the bridge will automatically insert a duplicate id property into each message that it forwards.
	 */
	@ModelNodeBinding(detypedName = "use-duplicate-detection")
	public Boolean useDuplicateDetection() {
		return this.useDuplicateDetection;
	}

	/**
	 * Whether the bridge will automatically insert a duplicate id property into each message that it forwards.
	 */
	@SuppressWarnings("unchecked")
	public Bridge useDuplicateDetection(Boolean value) {
		this.useDuplicateDetection = value;
		return (Bridge) this;
	}

	/**
	 * The user name to use when creating the bridge connection to the remote server. If it is not specified the default cluster user specified by the cluster-user attribute in the root messaging subsystem resource will be used.
	 */
	@ModelNodeBinding(detypedName = "user")
	public String user() {
		return this.user;
	}

	/**
	 * The user name to use when creating the bridge connection to the remote server. If it is not specified the default cluster user specified by the cluster-user attribute in the root messaging subsystem resource will be used.
	 */
	@SuppressWarnings("unchecked")
	public Bridge user(String value) {
		this.user = value;
		return (Bridge) this;
	}
}