package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.math.BigDecimal;
/**
 * Defines a connection factory.
 */
@ResourceType("connection-factory")
public class ConnectionFactory {

	private String key;
	private Boolean autoGroup;
	private Boolean blockOnAcknowledge;
	private Boolean blockOnDurableSend;
	private Boolean blockOnNonDurableSend;
	private Boolean cacheLargeMessageClient;
	private Long callFailoverTimeout;
	private Long callTimeout;
	private Long clientFailureCheckPeriod;
	private String clientId;
	private Boolean compressLargeMessages;
	private Integer confirmationWindowSize;
	private String connectionLoadBalancingPolicyClassName;
	private Long connectionTtl;
	private List<String> connectors;
	private Integer consumerMaxRate;
	private Integer consumerWindowSize;
	private String discoveryGroup;
	private Integer dupsOkBatchSize;
	private List<String> entries;
	private String factoryType;
	private Boolean failoverOnInitialConnection;
	private String groupId;
	private Boolean ha;
	private Long maxRetryInterval;
	private Integer minLargeMessageSize;
	private Boolean preAcknowledge;
	private Integer producerMaxRate;
	private Integer producerWindowSize;
	private Integer reconnectAttempts;
	private Long retryInterval;
	private BigDecimal retryIntervalMultiplier;
	private Integer scheduledThreadPoolMaxSize;
	private Integer threadPoolMaxSize;
	private Integer transactionBatchSize;
	private Boolean useGlobalPools;

	public ConnectionFactory(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Whether or not message grouping is automatically used
	 */
	@ModelNodeBinding(detypedName = "auto-group")
	public Boolean autoGroup() {
		return this.autoGroup;
	}

	/**
	 * Whether or not message grouping is automatically used
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory autoGroup(Boolean value) {
		this.autoGroup = value;
		return (ConnectionFactory) this;
	}

	/**
	 * True to set block on acknowledge.
	 */
	@ModelNodeBinding(detypedName = "block-on-acknowledge")
	public Boolean blockOnAcknowledge() {
		return this.blockOnAcknowledge;
	}

	/**
	 * True to set block on acknowledge.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory blockOnAcknowledge(Boolean value) {
		this.blockOnAcknowledge = value;
		return (ConnectionFactory) this;
	}

	/**
	 * True to set block on durable send.
	 */
	@ModelNodeBinding(detypedName = "block-on-durable-send")
	public Boolean blockOnDurableSend() {
		return this.blockOnDurableSend;
	}

	/**
	 * True to set block on durable send.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory blockOnDurableSend(Boolean value) {
		this.blockOnDurableSend = value;
		return (ConnectionFactory) this;
	}

	/**
	 * True to set block on non durable send.
	 */
	@ModelNodeBinding(detypedName = "block-on-non-durable-send")
	public Boolean blockOnNonDurableSend() {
		return this.blockOnNonDurableSend;
	}

	/**
	 * True to set block on non durable send.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory blockOnNonDurableSend(Boolean value) {
		this.blockOnNonDurableSend = value;
		return (ConnectionFactory) this;
	}

	/**
	 * True to cache large messages.
	 */
	@ModelNodeBinding(detypedName = "cache-large-message-client")
	public Boolean cacheLargeMessageClient() {
		return this.cacheLargeMessageClient;
	}

	/**
	 * True to cache large messages.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory cacheLargeMessageClient(Boolean value) {
		this.cacheLargeMessageClient = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The timeout to use when fail over is in process (in ms).
	 */
	@ModelNodeBinding(detypedName = "call-failover-timeout")
	public Long callFailoverTimeout() {
		return this.callFailoverTimeout;
	}

	/**
	 * The timeout to use when fail over is in process (in ms).
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory callFailoverTimeout(Long value) {
		this.callFailoverTimeout = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The call time out.
	 */
	@ModelNodeBinding(detypedName = "call-timeout")
	public Long callTimeout() {
		return this.callTimeout;
	}

	/**
	 * The call time out.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory callTimeout(Long value) {
		this.callTimeout = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The client failure check period.
	 */
	@ModelNodeBinding(detypedName = "client-failure-check-period")
	public Long clientFailureCheckPeriod() {
		return this.clientFailureCheckPeriod;
	}

	/**
	 * The client failure check period.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory clientFailureCheckPeriod(Long value) {
		this.clientFailureCheckPeriod = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The client id.
	 */
	@ModelNodeBinding(detypedName = "client-id")
	public String clientId() {
		return this.clientId;
	}

	/**
	 * The client id.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory clientId(String value) {
		this.clientId = value;
		return (ConnectionFactory) this;
	}

	/**
	 * Whether large messages should be compressed.
	 */
	@ModelNodeBinding(detypedName = "compress-large-messages")
	public Boolean compressLargeMessages() {
		return this.compressLargeMessages;
	}

	/**
	 * Whether large messages should be compressed.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory compressLargeMessages(Boolean value) {
		this.compressLargeMessages = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The confirmation window size.
	 */
	@ModelNodeBinding(detypedName = "confirmation-window-size")
	public Integer confirmationWindowSize() {
		return this.confirmationWindowSize;
	}

	/**
	 * The confirmation window size.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory confirmationWindowSize(Integer value) {
		this.confirmationWindowSize = value;
		return (ConnectionFactory) this;
	}

	/**
	 * Name of a class implementing a client-side load balancing policy that a client can use to load balance sessions across different nodes in a cluster.
	 */
	@ModelNodeBinding(detypedName = "connection-load-balancing-policy-class-name")
	public String connectionLoadBalancingPolicyClassName() {
		return this.connectionLoadBalancingPolicyClassName;
	}

	/**
	 * Name of a class implementing a client-side load balancing policy that a client can use to load balance sessions across different nodes in a cluster.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory connectionLoadBalancingPolicyClassName(String value) {
		this.connectionLoadBalancingPolicyClassName = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The connection ttl.
	 */
	@ModelNodeBinding(detypedName = "connection-ttl")
	public Long connectionTtl() {
		return this.connectionTtl;
	}

	/**
	 * The connection ttl.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory connectionTtl(Long value) {
		this.connectionTtl = value;
		return (ConnectionFactory) this;
	}

	/**
	 * Defines the connectors. These are stored in a map by connector name (with an undefined value). It is possible to pass a list of connector names when writing this attribute.
	 */
	@ModelNodeBinding(detypedName = "connectors")
	public List<String> connectors() {
		return this.connectors;
	}

	/**
	 * Defines the connectors. These are stored in a map by connector name (with an undefined value). It is possible to pass a list of connector names when writing this attribute.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory connectors(List<String> value) {
		this.connectors = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The consumer max rate.
	 */
	@ModelNodeBinding(detypedName = "consumer-max-rate")
	public Integer consumerMaxRate() {
		return this.consumerMaxRate;
	}

	/**
	 * The consumer max rate.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory consumerMaxRate(Integer value) {
		this.consumerMaxRate = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The consumer window size.
	 */
	@ModelNodeBinding(detypedName = "consumer-window-size")
	public Integer consumerWindowSize() {
		return this.consumerWindowSize;
	}

	/**
	 * The consumer window size.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory consumerWindowSize(Integer value) {
		this.consumerWindowSize = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The discovery group name.
	 */
	@ModelNodeBinding(detypedName = "discovery-group")
	public String discoveryGroup() {
		return this.discoveryGroup;
	}

	/**
	 * The discovery group name.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory discoveryGroup(String value) {
		this.discoveryGroup = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The dups ok batch size.
	 */
	@ModelNodeBinding(detypedName = "dups-ok-batch-size")
	public Integer dupsOkBatchSize() {
		return this.dupsOkBatchSize;
	}

	/**
	 * The dups ok batch size.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory dupsOkBatchSize(Integer value) {
		this.dupsOkBatchSize = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The jndi names the connection factory should be bound to.
	 */
	@ModelNodeBinding(detypedName = "entries")
	public List<String> entries() {
		return this.entries;
	}

	/**
	 * The jndi names the connection factory should be bound to.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory entries(List<String> value) {
		this.entries = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The type of connection factory.
	 */
	@ModelNodeBinding(detypedName = "factory-type")
	public String factoryType() {
		return this.factoryType;
	}

	/**
	 * The type of connection factory.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory factoryType(String value) {
		this.factoryType = value;
		return (ConnectionFactory) this;
	}

	/**
	 * True to fail over on initial connection.
	 */
	@ModelNodeBinding(detypedName = "failover-on-initial-connection")
	public Boolean failoverOnInitialConnection() {
		return this.failoverOnInitialConnection;
	}

	/**
	 * True to fail over on initial connection.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory failoverOnInitialConnection(Boolean value) {
		this.failoverOnInitialConnection = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The group id.
	 */
	@ModelNodeBinding(detypedName = "group-id")
	public String groupId() {
		return this.groupId;
	}

	/**
	 * The group id.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory groupId(String value) {
		this.groupId = value;
		return (ConnectionFactory) this;
	}

	/**
	 * Whether the connection factory supports High Availability.
	 */
	@ModelNodeBinding(detypedName = "ha")
	public Boolean ha() {
		return this.ha;
	}

	/**
	 * Whether the connection factory supports High Availability.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory ha(Boolean value) {
		this.ha = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The max retry interval.
	 */
	@ModelNodeBinding(detypedName = "max-retry-interval")
	public Long maxRetryInterval() {
		return this.maxRetryInterval;
	}

	/**
	 * The max retry interval.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory maxRetryInterval(Long value) {
		this.maxRetryInterval = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The min large message size.
	 */
	@ModelNodeBinding(detypedName = "min-large-message-size")
	public Integer minLargeMessageSize() {
		return this.minLargeMessageSize;
	}

	/**
	 * The min large message size.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory minLargeMessageSize(Integer value) {
		this.minLargeMessageSize = value;
		return (ConnectionFactory) this;
	}

	/**
	 * True to pre-acknowledge.
	 */
	@ModelNodeBinding(detypedName = "pre-acknowledge")
	public Boolean preAcknowledge() {
		return this.preAcknowledge;
	}

	/**
	 * True to pre-acknowledge.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory preAcknowledge(Boolean value) {
		this.preAcknowledge = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The producer max rate.
	 */
	@ModelNodeBinding(detypedName = "producer-max-rate")
	public Integer producerMaxRate() {
		return this.producerMaxRate;
	}

	/**
	 * The producer max rate.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory producerMaxRate(Integer value) {
		this.producerMaxRate = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The producer window size.
	 */
	@ModelNodeBinding(detypedName = "producer-window-size")
	public Integer producerWindowSize() {
		return this.producerWindowSize;
	}

	/**
	 * The producer window size.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory producerWindowSize(Integer value) {
		this.producerWindowSize = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The reconnect attempts.
	 */
	@ModelNodeBinding(detypedName = "reconnect-attempts")
	public Integer reconnectAttempts() {
		return this.reconnectAttempts;
	}

	/**
	 * The reconnect attempts.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory reconnectAttempts(Integer value) {
		this.reconnectAttempts = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The retry interval.
	 */
	@ModelNodeBinding(detypedName = "retry-interval")
	public Long retryInterval() {
		return this.retryInterval;
	}

	/**
	 * The retry interval.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory retryInterval(Long value) {
		this.retryInterval = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The retry interval multiplier.
	 */
	@ModelNodeBinding(detypedName = "retry-interval-multiplier")
	public BigDecimal retryIntervalMultiplier() {
		return this.retryIntervalMultiplier;
	}

	/**
	 * The retry interval multiplier.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory retryIntervalMultiplier(BigDecimal value) {
		this.retryIntervalMultiplier = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The scheduled thread pool max size.
	 */
	@ModelNodeBinding(detypedName = "scheduled-thread-pool-max-size")
	public Integer scheduledThreadPoolMaxSize() {
		return this.scheduledThreadPoolMaxSize;
	}

	/**
	 * The scheduled thread pool max size.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory scheduledThreadPoolMaxSize(Integer value) {
		this.scheduledThreadPoolMaxSize = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The thread pool max size.
	 */
	@ModelNodeBinding(detypedName = "thread-pool-max-size")
	public Integer threadPoolMaxSize() {
		return this.threadPoolMaxSize;
	}

	/**
	 * The thread pool max size.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory threadPoolMaxSize(Integer value) {
		this.threadPoolMaxSize = value;
		return (ConnectionFactory) this;
	}

	/**
	 * The transaction batch size.
	 */
	@ModelNodeBinding(detypedName = "transaction-batch-size")
	public Integer transactionBatchSize() {
		return this.transactionBatchSize;
	}

	/**
	 * The transaction batch size.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory transactionBatchSize(Integer value) {
		this.transactionBatchSize = value;
		return (ConnectionFactory) this;
	}

	/**
	 * True to use global pools.
	 */
	@ModelNodeBinding(detypedName = "use-global-pools")
	public Boolean useGlobalPools() {
		return this.useGlobalPools;
	}

	/**
	 * True to use global pools.
	 */
	@SuppressWarnings("unchecked")
	public ConnectionFactory useGlobalPools(Boolean value) {
		this.useGlobalPools = value;
		return (ConnectionFactory) this;
	}
}