package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * TODO
 */
@ResourceType("connector-service")
public class ConnectorService {

	private String key;
	private String factoryClass;
	private Map params;

	public ConnectorService(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Class name of the factory class that can instantiate the connector service.
	 */
	@ModelNodeBinding(detypedName = "factory-class")
	public String factoryClass() {
		return this.factoryClass;
	}

	/**
	 * Class name of the factory class that can instantiate the connector service.
	 */
	@SuppressWarnings("unchecked")
	public ConnectorService factoryClass(String value) {
		this.factoryClass = value;
		return (ConnectorService) this;
	}

	/**
	 * A key/value pair understood by the connector service's factory-class
	 */
	@ModelNodeBinding(detypedName = "params")
	public Map params() {
		return this.params;
	}

	/**
	 * A key/value pair understood by the connector service's factory-class
	 */
	@SuppressWarnings("unchecked")
	public ConnectorService params(Map value) {
		this.params = value;
		return (ConnectorService) this;
	}
}