package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * Used by a remote client to define how it connects to a server over HTTP.
 */
@ResourceType("http-connector")
public class HttpConnector {

	private String key;
	private String endpoint;
	private Map params;
	private String socketBinding;

	public HttpConnector(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The http-acceptor that serves as the endpoint of this http-connector.
	 */
	@ModelNodeBinding(detypedName = "endpoint")
	public String endpoint() {
		return this.endpoint;
	}

	/**
	 * The http-acceptor that serves as the endpoint of this http-connector.
	 */
	@SuppressWarnings("unchecked")
	public HttpConnector endpoint(String value) {
		this.endpoint = value;
		return (HttpConnector) this;
	}

	/**
	 * A key-value pair understood by the connector factory-class and used to configure it.
	 */
	@ModelNodeBinding(detypedName = "params")
	public Map params() {
		return this.params;
	}

	/**
	 * A key-value pair understood by the connector factory-class and used to configure it.
	 */
	@SuppressWarnings("unchecked")
	public HttpConnector params(Map value) {
		this.params = value;
		return (HttpConnector) this;
	}

	/**
	 * The socket binding that the connector will use to create connections.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * The socket binding that the connector will use to create connections.
	 */
	@SuppressWarnings("unchecked")
	public HttpConnector socketBinding(String value) {
		this.socketBinding = value;
		return (HttpConnector) this;
	}
}