package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A Queue.
 */
@ResourceType("queue")
public class Queue {

	private String key;
	private Integer consumerCount;
	private String deadLetterAddress;
	private Integer deliveringCount;
	private Boolean durable;
	private String expiryAddress;
	private String filter;
	private Long id;
	private Long messageCount;
	private Long messagesAdded;
	private Boolean paused;
	private String queueAddress;
	private Long scheduledCount;
	private Boolean temporary;

	public Queue(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The number of consumers consuming messages from this queue.
	 */
	@ModelNodeBinding(detypedName = "consumer-count")
	public Integer consumerCount() {
		return this.consumerCount;
	}

	/**
	 * The number of consumers consuming messages from this queue.
	 */
	@SuppressWarnings("unchecked")
	public Queue consumerCount(Integer value) {
		this.consumerCount = value;
		return (Queue) this;
	}

	/**
	 * The address to send the queue's dead messages to.
	 */
	@ModelNodeBinding(detypedName = "dead-letter-address")
	public String deadLetterAddress() {
		return this.deadLetterAddress;
	}

	/**
	 * The address to send the queue's dead messages to.
	 */
	@SuppressWarnings("unchecked")
	public Queue deadLetterAddress(String value) {
		this.deadLetterAddress = value;
		return (Queue) this;
	}

	/**
	 * The number of messages that this queue is currently delivering to its consumers.
	 */
	@ModelNodeBinding(detypedName = "delivering-count")
	public Integer deliveringCount() {
		return this.deliveringCount;
	}

	/**
	 * The number of messages that this queue is currently delivering to its consumers.
	 */
	@SuppressWarnings("unchecked")
	public Queue deliveringCount(Integer value) {
		this.deliveringCount = value;
		return (Queue) this;
	}

	/**
	 * Defines whether the queue is durable.
	 */
	@ModelNodeBinding(detypedName = "durable")
	public Boolean durable() {
		return this.durable;
	}

	/**
	 * Defines whether the queue is durable.
	 */
	@SuppressWarnings("unchecked")
	public Queue durable(Boolean value) {
		this.durable = value;
		return (Queue) this;
	}

	/**
	 * The address to send the queue's expired messages to.
	 */
	@ModelNodeBinding(detypedName = "expiry-address")
	public String expiryAddress() {
		return this.expiryAddress;
	}

	/**
	 * The address to send the queue's expired messages to.
	 */
	@SuppressWarnings("unchecked")
	public Queue expiryAddress(String value) {
		this.expiryAddress = value;
		return (Queue) this;
	}

	/**
	 * A queue message filter definition. An undefined or empty filter will match all messages.
	 */
	@ModelNodeBinding(detypedName = "filter")
	public String filter() {
		return this.filter;
	}

	/**
	 * A queue message filter definition. An undefined or empty filter will match all messages.
	 */
	@SuppressWarnings("unchecked")
	public Queue filter(String value) {
		this.filter = value;
		return (Queue) this;
	}

	/**
	 * The id of the queue.
	 */
	@ModelNodeBinding(detypedName = "id")
	public Long id() {
		return this.id;
	}

	/**
	 * The id of the queue.
	 */
	@SuppressWarnings("unchecked")
	public Queue id(Long value) {
		this.id = value;
		return (Queue) this;
	}

	/**
	 * The number of messages currently in this queue.
	 */
	@ModelNodeBinding(detypedName = "message-count")
	public Long messageCount() {
		return this.messageCount;
	}

	/**
	 * The number of messages currently in this queue.
	 */
	@SuppressWarnings("unchecked")
	public Queue messageCount(Long value) {
		this.messageCount = value;
		return (Queue) this;
	}

	/**
	 * The number of messages added to this queue since it was created.
	 */
	@ModelNodeBinding(detypedName = "messages-added")
	public Long messagesAdded() {
		return this.messagesAdded;
	}

	/**
	 * The number of messages added to this queue since it was created.
	 */
	@SuppressWarnings("unchecked")
	public Queue messagesAdded(Long value) {
		this.messagesAdded = value;
		return (Queue) this;
	}

	/**
	 * Whether the queue is paused.
	 */
	@ModelNodeBinding(detypedName = "paused")
	public Boolean paused() {
		return this.paused;
	}

	/**
	 * Whether the queue is paused.
	 */
	@SuppressWarnings("unchecked")
	public Queue paused(Boolean value) {
		this.paused = value;
		return (Queue) this;
	}

	/**
	 * The queue address defines what address is used for routing messages.
	 */
	@ModelNodeBinding(detypedName = "queue-address")
	public String queueAddress() {
		return this.queueAddress;
	}

	/**
	 * The queue address defines what address is used for routing messages.
	 */
	@SuppressWarnings("unchecked")
	public Queue queueAddress(String value) {
		this.queueAddress = value;
		return (Queue) this;
	}

	/**
	 * The number of scheduled messages in this queue.
	 */
	@ModelNodeBinding(detypedName = "scheduled-count")
	public Long scheduledCount() {
		return this.scheduledCount;
	}

	/**
	 * The number of scheduled messages in this queue.
	 */
	@SuppressWarnings("unchecked")
	public Queue scheduledCount(Long value) {
		this.scheduledCount = value;
		return (Queue) this;
	}

	/**
	 * Whether the queue is temporary.
	 */
	@ModelNodeBinding(detypedName = "temporary")
	public Boolean temporary() {
		return this.temporary;
	}

	/**
	 * Whether the queue is temporary.
	 */
	@SuppressWarnings("unchecked")
	public Queue temporary(Boolean value) {
		this.temporary = value;
		return (Queue) this;
	}
}