package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.messaging_activemq.server.ha_policy.replication_colocated.MasterConfiguration;
import org.wildfly.swarm.config.messaging_activemq.server.ha_policy.replication_colocated.SlaveConfiguration;
/**
 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
 */
@ResourceType("ha-policy")
@Implicit
public class ReplicationColocatedHaPolicy {

	private String key;
	private Integer backupPortOffset;
	private Integer backupRequestRetries;
	private Long backupRequestRetryInterval;
	private List<String> excludedConnectors;
	private Integer maxBackups;
	private Boolean requestBackup;
	private MasterConfiguration masterConfiguration;
	private SlaveConfiguration slaveConfiguration;

	public ReplicationColocatedHaPolicy() {
		this.key = "replication-colocated";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The offset to use for the Connectors and Acceptors when creating a new backup server.
	 */
	@ModelNodeBinding(detypedName = "backup-port-offset")
	public Integer backupPortOffset() {
		return this.backupPortOffset;
	}

	/**
	 * The offset to use for the Connectors and Acceptors when creating a new backup server.
	 */
	@SuppressWarnings("unchecked")
	public ReplicationColocatedHaPolicy backupPortOffset(Integer value) {
		this.backupPortOffset = value;
		return (ReplicationColocatedHaPolicy) this;
	}

	/**
	 * How many times the live server will try to request a backup, -1 means for ever.
	 */
	@ModelNodeBinding(detypedName = "backup-request-retries")
	public Integer backupRequestRetries() {
		return this.backupRequestRetries;
	}

	/**
	 * How many times the live server will try to request a backup, -1 means for ever.
	 */
	@SuppressWarnings("unchecked")
	public ReplicationColocatedHaPolicy backupRequestRetries(Integer value) {
		this.backupRequestRetries = value;
		return (ReplicationColocatedHaPolicy) this;
	}

	/**
	 * How long (in ms) to wait for retries between attempts to request a backup server.
	 */
	@ModelNodeBinding(detypedName = "backup-request-retry-interval")
	public Long backupRequestRetryInterval() {
		return this.backupRequestRetryInterval;
	}

	/**
	 * How long (in ms) to wait for retries between attempts to request a backup server.
	 */
	@SuppressWarnings("unchecked")
	public ReplicationColocatedHaPolicy backupRequestRetryInterval(Long value) {
		this.backupRequestRetryInterval = value;
		return (ReplicationColocatedHaPolicy) this;
	}

	/**
	 * The connectors that must not have their port offset.
	 */
	@ModelNodeBinding(detypedName = "excluded-connectors")
	public List<String> excludedConnectors() {
		return this.excludedConnectors;
	}

	/**
	 * The connectors that must not have their port offset.
	 */
	@SuppressWarnings("unchecked")
	public ReplicationColocatedHaPolicy excludedConnectors(List<String> value) {
		this.excludedConnectors = value;
		return (ReplicationColocatedHaPolicy) this;
	}

	/**
	 * Whether or not this live server will accept backup requests from other live servers.
	 */
	@ModelNodeBinding(detypedName = "max-backups")
	public Integer maxBackups() {
		return this.maxBackups;
	}

	/**
	 * Whether or not this live server will accept backup requests from other live servers.
	 */
	@SuppressWarnings("unchecked")
	public ReplicationColocatedHaPolicy maxBackups(Integer value) {
		this.maxBackups = value;
		return (ReplicationColocatedHaPolicy) this;
	}

	/**
	 * If true then the server will request a backup on another node.
	 */
	@ModelNodeBinding(detypedName = "request-backup")
	public Boolean requestBackup() {
		return this.requestBackup;
	}

	/**
	 * If true then the server will request a backup on another node.
	 */
	@SuppressWarnings("unchecked")
	public ReplicationColocatedHaPolicy requestBackup(Boolean value) {
		this.requestBackup = value;
		return (ReplicationColocatedHaPolicy) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public MasterConfiguration masterConfiguration() {
		return this.masterConfiguration;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public ReplicationColocatedHaPolicy masterConfiguration(
			MasterConfiguration value) {
		this.masterConfiguration = value;
		return (ReplicationColocatedHaPolicy) this;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@Subresource
	public SlaveConfiguration slaveConfiguration() {
		return this.slaveConfiguration;
	}

	/**
	 * A messaging resource that allows you to configure High Availability for the ActiveMQ server (the value of ha-policy can be live-only, replication-master, replication-slave, or replication-colocated).
	 */
	@SuppressWarnings("unchecked")
	public ReplicationColocatedHaPolicy slaveConfiguration(
			SlaveConfiguration value) {
		this.slaveConfiguration = value;
		return (ReplicationColocatedHaPolicy) this;
	}
}