package org.wildfly.swarm.config.messaging_activemq.server;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A security role.
 */
@ResourceType("role")
public class Role {

	private String key;
	private Boolean consume;
	private Boolean createDurableQueue;
	private Boolean createNonDurableQueue;
	private Boolean deleteDurableQueue;
	private Boolean deleteNonDurableQueue;
	private Boolean manage;
	private Boolean send;

	public Role(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * his permission allows the user to consume a message from a queue bound to matching addresses.
	 */
	@ModelNodeBinding(detypedName = "consume")
	public Boolean consume() {
		return this.consume;
	}

	/**
	 * his permission allows the user to consume a message from a queue bound to matching addresses.
	 */
	@SuppressWarnings("unchecked")
	public Role consume(Boolean value) {
		this.consume = value;
		return (Role) this;
	}

	/**
	 * This permission allows the user to create a durable queue.
	 */
	@ModelNodeBinding(detypedName = "create-durable-queue")
	public Boolean createDurableQueue() {
		return this.createDurableQueue;
	}

	/**
	 * This permission allows the user to create a durable queue.
	 */
	@SuppressWarnings("unchecked")
	public Role createDurableQueue(Boolean value) {
		this.createDurableQueue = value;
		return (Role) this;
	}

	/**
	 * This permission allows the user to create a temporary queue.
	 */
	@ModelNodeBinding(detypedName = "create-non-durable-queue")
	public Boolean createNonDurableQueue() {
		return this.createNonDurableQueue;
	}

	/**
	 * This permission allows the user to create a temporary queue.
	 */
	@SuppressWarnings("unchecked")
	public Role createNonDurableQueue(Boolean value) {
		this.createNonDurableQueue = value;
		return (Role) this;
	}

	/**
	 * This permission allows the user to delete a durable queue.
	 */
	@ModelNodeBinding(detypedName = "delete-durable-queue")
	public Boolean deleteDurableQueue() {
		return this.deleteDurableQueue;
	}

	/**
	 * This permission allows the user to delete a durable queue.
	 */
	@SuppressWarnings("unchecked")
	public Role deleteDurableQueue(Boolean value) {
		this.deleteDurableQueue = value;
		return (Role) this;
	}

	/**
	 * This permission allows the user to delete a temporary queue.
	 */
	@ModelNodeBinding(detypedName = "delete-non-durable-queue")
	public Boolean deleteNonDurableQueue() {
		return this.deleteNonDurableQueue;
	}

	/**
	 * This permission allows the user to delete a temporary queue.
	 */
	@SuppressWarnings("unchecked")
	public Role deleteNonDurableQueue(Boolean value) {
		this.deleteNonDurableQueue = value;
		return (Role) this;
	}

	/**
	 * This permission allows the user to invoke management operations by sending management messages to the management address.
	 */
	@ModelNodeBinding(detypedName = "manage")
	public Boolean manage() {
		return this.manage;
	}

	/**
	 * This permission allows the user to invoke management operations by sending management messages to the management address.
	 */
	@SuppressWarnings("unchecked")
	public Role manage(Boolean value) {
		this.manage = value;
		return (Role) this;
	}

	/**
	 * This permission allows the user to send a message to matching addresses.
	 */
	@ModelNodeBinding(detypedName = "send")
	public Boolean send() {
		return this.send;
	}

	/**
	 * This permission allows the user to send a message to matching addresses.
	 */
	@SuppressWarnings("unchecked")
	public Role send(Boolean value) {
		this.send = value;
		return (Role) this;
	}
}