package org.wildfly.swarm.config.remoting;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Endpoint configuration
 */
@ResourceType("configuration")
@Implicit
public class EndpointConfiguration {

	private String key;
	private String authRealm;
	private Integer authenticationRetries;
	private String authorizeId;
	private Integer bufferRegionSize;
	private Integer heartbeatInterval;
	private Integer maxInboundChannels;
	private Long maxInboundMessageSize;
	private Integer maxInboundMessages;
	private Integer maxOutboundChannels;
	private Long maxOutboundMessageSize;
	private Integer maxOutboundMessages;
	private Integer receiveBufferSize;
	private Integer receiveWindowSize;
	private String saslProtocol;
	private Integer sendBufferSize;
	private String serverName;
	private Integer transmitWindowSize;
	private String worker;

	public EndpointConfiguration() {
		this.key = "endpoint";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The authentication realm to use if no authentication {@code CallbackHandler} is specified.
	 */
	@ModelNodeBinding(detypedName = "auth-realm")
	public String authRealm() {
		return this.authRealm;
	}

	/**
	 * The authentication realm to use if no authentication {@code CallbackHandler} is specified.
	 */
	@SuppressWarnings("unchecked")
	public EndpointConfiguration authRealm(String value) {
		this.authRealm = value;
		return (EndpointConfiguration) this;
	}

	/**
	 * Specify the number of times a client is allowed to retry authentication before closing the connection.
	 */
	@ModelNodeBinding(detypedName = "authentication-retries")
	public Integer authenticationRetries() {
		return this.authenticationRetries;
	}

	/**
	 * Specify the number of times a client is allowed to retry authentication before closing the connection.
	 */
	@SuppressWarnings("unchecked")
	public EndpointConfiguration authenticationRetries(Integer value) {
		this.authenticationRetries = value;
		return (EndpointConfiguration) this;
	}

	/**
	 * The SASL authorization ID.  Used as authentication user name to use if no authentication {@code CallbackHandler} is specifiedand the selected SASL mechanism demands a user name.
	 */
	@ModelNodeBinding(detypedName = "authorize-id")
	public String authorizeId() {
		return this.authorizeId;
	}

	/**
	 * The SASL authorization ID.  Used as authentication user name to use if no authentication {@code CallbackHandler} is specifiedand the selected SASL mechanism demands a user name.
	 */
	@SuppressWarnings("unchecked")
	public EndpointConfiguration authorizeId(String value) {
		this.authorizeId = value;
		return (EndpointConfiguration) this;
	}

	/**
	 * The size of allocated buffer regions.
	 */
	@ModelNodeBinding(detypedName = "buffer-region-size")
	public Integer bufferRegionSize() {
		return this.bufferRegionSize;
	}

	/**
	 * The size of allocated buffer regions.
	 */
	@SuppressWarnings("unchecked")
	public EndpointConfiguration bufferRegionSize(Integer value) {
		this.bufferRegionSize = value;
		return (EndpointConfiguration) this;
	}

	/**
	 * The interval to use for connection heartbeat, in milliseconds.  If the connection is idle in the outbound directionfor this amount of time, a ping message will be sent, which will trigger a corresponding reply message.
	 */
	@ModelNodeBinding(detypedName = "heartbeat-interval")
	public Integer heartbeatInterval() {
		return this.heartbeatInterval;
	}

	/**
	 * The interval to use for connection heartbeat, in milliseconds.  If the connection is idle in the outbound directionfor this amount of time, a ping message will be sent, which will trigger a corresponding reply message.
	 */
	@SuppressWarnings("unchecked")
	public EndpointConfiguration heartbeatInterval(Integer value) {
		this.heartbeatInterval = value;
		return (EndpointConfiguration) this;
	}

	/**
	 * The maximum number of concurrent inbound messages on a channel.
	 */
	@ModelNodeBinding(detypedName = "max-inbound-channels")
	public Integer maxInboundChannels() {
		return this.maxInboundChannels;
	}

	/**
	 * The maximum number of concurrent inbound messages on a channel.
	 */
	@SuppressWarnings("unchecked")
	public EndpointConfiguration maxInboundChannels(Integer value) {
		this.maxInboundChannels = value;
		return (EndpointConfiguration) this;
	}

	/**
	 * The maximum inbound message size to be allowed.  Messages exceeding this size will cause an exception to be thrown on the reading side as well as the writing side.
	 */
	@ModelNodeBinding(detypedName = "max-inbound-message-size")
	public Long maxInboundMessageSize() {
		return this.maxInboundMessageSize;
	}

	/**
	 * The maximum inbound message size to be allowed.  Messages exceeding this size will cause an exception to be thrown on the reading side as well as the writing side.
	 */
	@SuppressWarnings("unchecked")
	public EndpointConfiguration maxInboundMessageSize(Long value) {
		this.maxInboundMessageSize = value;
		return (EndpointConfiguration) this;
	}

	/**
	 * The maximum number of inbound channels to support for a connection.
	 */
	@ModelNodeBinding(detypedName = "max-inbound-messages")
	public Integer maxInboundMessages() {
		return this.maxInboundMessages;
	}

	/**
	 * The maximum number of inbound channels to support for a connection.
	 */
	@SuppressWarnings("unchecked")
	public EndpointConfiguration maxInboundMessages(Integer value) {
		this.maxInboundMessages = value;
		return (EndpointConfiguration) this;
	}

	/**
	 * The maximum number of concurrent outbound messages on a channel.
	 */
	@ModelNodeBinding(detypedName = "max-outbound-channels")
	public Integer maxOutboundChannels() {
		return this.maxOutboundChannels;
	}

	/**
	 * The maximum number of concurrent outbound messages on a channel.
	 */
	@SuppressWarnings("unchecked")
	public EndpointConfiguration maxOutboundChannels(Integer value) {
		this.maxOutboundChannels = value;
		return (EndpointConfiguration) this;
	}

	/**
	 * The maximum outbound message size to send.  No messages larger than this well be transmitted; attempting to do so will cause an exception on the writing side.
	 */
	@ModelNodeBinding(detypedName = "max-outbound-message-size")
	public Long maxOutboundMessageSize() {
		return this.maxOutboundMessageSize;
	}

	/**
	 * The maximum outbound message size to send.  No messages larger than this well be transmitted; attempting to do so will cause an exception on the writing side.
	 */
	@SuppressWarnings("unchecked")
	public EndpointConfiguration maxOutboundMessageSize(Long value) {
		this.maxOutboundMessageSize = value;
		return (EndpointConfiguration) this;
	}

	/**
	 * The maximum number of outbound channels to support for a connection.
	 */
	@ModelNodeBinding(detypedName = "max-outbound-messages")
	public Integer maxOutboundMessages() {
		return this.maxOutboundMessages;
	}

	/**
	 * The maximum number of outbound channels to support for a connection.
	 */
	@SuppressWarnings("unchecked")
	public EndpointConfiguration maxOutboundMessages(Integer value) {
		this.maxOutboundMessages = value;
		return (EndpointConfiguration) this;
	}

	/**
	 * The size of the largest buffer that this endpoint will accept over a connection.
	 */
	@ModelNodeBinding(detypedName = "receive-buffer-size")
	public Integer receiveBufferSize() {
		return this.receiveBufferSize;
	}

	/**
	 * The size of the largest buffer that this endpoint will accept over a connection.
	 */
	@SuppressWarnings("unchecked")
	public EndpointConfiguration receiveBufferSize(Integer value) {
		this.receiveBufferSize = value;
		return (EndpointConfiguration) this;
	}

	/**
	 * The maximum window size of the receive direction for connection channels, in bytes.
	 */
	@ModelNodeBinding(detypedName = "receive-window-size")
	public Integer receiveWindowSize() {
		return this.receiveWindowSize;
	}

	/**
	 * The maximum window size of the receive direction for connection channels, in bytes.
	 */
	@SuppressWarnings("unchecked")
	public EndpointConfiguration receiveWindowSize(Integer value) {
		this.receiveWindowSize = value;
		return (EndpointConfiguration) this;
	}

	/**
	 * Where a SaslServer or SaslClient are created by default the protocol specified it 'remoting', this can be used to override this.
	 */
	@ModelNodeBinding(detypedName = "sasl-protocol")
	public String saslProtocol() {
		return this.saslProtocol;
	}

	/**
	 * Where a SaslServer or SaslClient are created by default the protocol specified it 'remoting', this can be used to override this.
	 */
	@SuppressWarnings("unchecked")
	public EndpointConfiguration saslProtocol(String value) {
		this.saslProtocol = value;
		return (EndpointConfiguration) this;
	}

	/**
	 * The size of the largest buffer that this endpoint will transmit over a connection.
	 */
	@ModelNodeBinding(detypedName = "send-buffer-size")
	public Integer sendBufferSize() {
		return this.sendBufferSize;
	}

	/**
	 * The size of the largest buffer that this endpoint will transmit over a connection.
	 */
	@SuppressWarnings("unchecked")
	public EndpointConfiguration sendBufferSize(Integer value) {
		this.sendBufferSize = value;
		return (EndpointConfiguration) this;
	}

	/**
	 * The server side of the connection passes it's name to the client in the initial greeting, by default the name is automatically discovered from the local address of the connection or it can be overridden using this.
	 */
	@ModelNodeBinding(detypedName = "server-name")
	public String serverName() {
		return this.serverName;
	}

	/**
	 * The server side of the connection passes it's name to the client in the initial greeting, by default the name is automatically discovered from the local address of the connection or it can be overridden using this.
	 */
	@SuppressWarnings("unchecked")
	public EndpointConfiguration serverName(String value) {
		this.serverName = value;
		return (EndpointConfiguration) this;
	}

	/**
	 * The maximum window size of the transmit direction for connection channels, in bytes.
	 */
	@ModelNodeBinding(detypedName = "transmit-window-size")
	public Integer transmitWindowSize() {
		return this.transmitWindowSize;
	}

	/**
	 * The maximum window size of the transmit direction for connection channels, in bytes.
	 */
	@SuppressWarnings("unchecked")
	public EndpointConfiguration transmitWindowSize(Integer value) {
		this.transmitWindowSize = value;
		return (EndpointConfiguration) this;
	}

	/**
	 * Worker to use
	 */
	@ModelNodeBinding(detypedName = "worker")
	public String worker() {
		return this.worker;
	}

	/**
	 * Worker to use
	 */
	@SuppressWarnings("unchecked")
	public EndpointConfiguration worker(String value) {
		this.worker = value;
		return (EndpointConfiguration) this;
	}
}