package org.wildfly.swarm.config.remoting;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Properties supported by the underlying provider. The property name is inferred from the last element of the properties address.
 */
@ResourceType("property")
public class Property {

	private String key;
	private String value;

	public Property(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The property value.
	 */
	@ModelNodeBinding(detypedName = "value")
	public String value() {
		return this.value;
	}

	/**
	 * The property value.
	 */
	@SuppressWarnings("unchecked")
	public Property value(String value) {
		this.value = value;
		return (Property) this;
	}
}